// Copyright (C) Microsoft Corporation. All rights reserved.
import{LitElement as t,html as e,css as i,when as s,repeat as o}from"../../common/lit.js";import{market as r}from"../../common/environment.js";import{proxyHttpFetch as n}from"../../common/proxy.js";import{debounce as a}from"../../common/utils.js";import"./list-item-site.js";import"../../common/dewey/dewey-button.js";import c from"../../common/i18n.js";import{TOPSISE_SERVER as m,toggleTopsiteItem as h,urlEqual as l,voiceoverEnable as u,getAndIncreaseNextDefaultIconGroupId as d}from"../utils/index.js";import{ActionName as p,SiteValue as g}from"../utils/histogram.js";import{LogError as y}from"../utils/actions.js";import{RecordBool as f}from"../../common/log.js";customElements.define("search-suggestion",class extends t{static get styles(){return i`
      :host {
        display: flex;
        flex-direction: column;
        justify-content: start;
        height: 100%;
        padding-bottom: 34px;
        box-sizing: border-box;
        overflow: hidden;
      }

      .no-result {
        margin-bottom: 6px;
        font-size: 15rem;
        line-height: 20rem;
        text-align: center;
        color: var(--text-secondary);
      }

      .list-container {
        overflow: auto;
      }

      .btn-custom-add {
        margin: 0 auto;
        margin-top: 18px;
      }

      .search-suggestion-label {
        position: absolute;
        top: 0;
        left: 0;
        opacity: 0;
        pointer-events: none;
      }
    `}static get properties(){return{keyword:{type:String},items:{type:Array},currentList:{type:Array},onClickCustomAdd:{type:Function},onResult:{type:Function},onToggle:{type:Function}}}constructor(){super(),this.currentList=[],this.items=[],this.cacheMap=new Map,this.querySearchList=a(this.querySearchList,250)}updated(t){super.updated(t),t.has("keyword")&&(this.keyword?(this.emptyTimeout&&clearTimeout(this.emptyTimeout),this.querySearchList()):this.emptyTimeout=setTimeout((()=>{this.keyword||this.updateSearchList(null)}),300))}querySearchList(){if(!this.keyword)return void this.updateSearchList(null);const t=this.keyword,e=this.queryItemFromCache(t);e?this.updateSearchList(e):n(`${m}/navsitesearch?query=${encodeURIComponent(t)}&market=${r}`).then((t=>(t.ok||y(`Adding page search failed, error code: ${t.status}, error msg: ${t.statusText}`),t.json()))).then((e=>{const i=e?.mobileNavSiteResult?.map((t=>({...t,site_id:g.Search})))??[];i?.forEach((t=>{void 0===t.defaultIconGroupId&&(t.defaultIconGroupId=d())})),this.updateCache(t,i),t===this.keyword&&this.updateSearchList(i),f(p.SearchLoadResult,i.length>0)})).catch((t=>{}))}updateSearchList(t){t&&(this.items=t),this.onResult?.(!!t)}queryItemFromCache(t){const e=this.cacheMap.get(t);return e?(e.timestamp=Date.now(),e.items):null}updateCache(t,e){if(this.cacheMap.set(t,{items:e,timestamp:Date.now()}),this.cacheMap.size>10){let t;this.cacheMap.forEach((({timestamp:e},i,s)=>{(!t||s.get(t).timestamp>e)&&(t=i)})),this.cacheMap.delete(t)}}onClickItemToggle(t){h(t,(t=>{t&&this.onToggle?.()}))}renderList(){const t=this.currentList||[],i=this.items?.map((e=>({...e,checked:t.some((t=>l(t.url,e.url)))})))||[];return e`
      <div role="region" id="searchSuggestion" aria-live="polite">
        <p class="search-suggestion-label" id="suggestionAnnouncement" tabindex='-1'>
          ${i.length>1?c.text("tsp_search_multiple_suggestions",{number:i.length}):c.text("tsp_search_one_suggestion")}
        </p>
      </div>
      <div class="list-container">
        ${o(i,(t=>t.url),((t,s)=>e`
              <list-item-site
                role=${u?"checkbox":""}
                aria-label=${`list ${s+1} of ${i.length}, ${t.title}, ${t.url}`}
                aria-checked=${t.checked}
                @click=${()=>u&&this.onClickItemToggle(t)}
                .item=${t}
                .onToggle=${()=>this.onClickItemToggle(t)}
              />
            `))}
      </div>
    `}render(){return e`
      ${s(this.items?.length>0,(()=>this.renderList()),(()=>e`
            <div class="no-result" aria-live="polite">${c.text("tsp_search_empty")}</div>`))}
      <dewey-button class="btn-custom-add" size="medium" type="outline-accent" @click=${this.onClickCustomAdd}>
        ${c.text(["tsp_custom_add"])}
      </dewey-button>
    `}});