// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{LitElement as e,html as i,css as t,classMap as o,when as c}from"../../common/lit.js";import{toggleTopsiteItem as n,isNoBorderIconEnabled as r}from"../utils/index.js";import"./edge-topsite-favicon.js";import"./edge-icon.js";customElements.define("topsite-item-card",class extends e{static get properties(){return{item:{type:Object},onToggle:{type:Function}}}static get styles(){return t`
      .item {
        display: block;
      }

      .icon-box {
        display: block;
        position: relative;
        width: 48px;
        height: 48px;
        border-radius: 12px;
        margin: 0 auto;
        transition: background 100ms;
      }

      .no-border-icon-box {
        width: 52px;
        height: 52px;
      }

      .icon-box.disabled {
        background: var(--surfaces-quaternary);
      }

      edge-topsite-favicon {
        position: absolute;
        top: 0;
        left: 0;
      }

      edge-checked-icon, edge-unchecked-icon {
        position: absolute;
        top: 2px;
        right: 2px;
        transform: translate(50%, -50%);
        border-radius: 50%;
        transition: opacity 300ms ease;
        will-change: opacity;
      }

      edge-checked-icon {
        opacity: 0;
      }

      .checked edge-checked-icon {
        opacity: 1.0;
      }

      .checked edge-unchecked-icon {
        opacity: 0;
      }

      .title {
        text-align: center;
        font-size: 12rem;
        line-height: 16rem;
        min-height: 16rem;
        color: var(--text-primary);
        margin: 5px 0;
        overflow: hidden;
        text-overflow: ellipsis;
        word-break: break-word;
        display: -webkit-box;
        -webkit-box-orient: vertical;
        -webkit-line-clamp: 2;
      }

      @media (prefers-color-scheme: dark) {
        .title {
          color: var(--text-dominant);
        }
      }
    `}constructor(){super(),this.onItemClick=this.onItemClick.bind(this)}connectedCallback(){super.connectedCallback()}onItemClick(){this.item.title&&this.item.url&&n(this.item,(e=>{e&&this.onToggle()}))}render(){const e=!this.item.title||!this.item.url,t={"icon-box":!0,"no-border-icon-box":r,disabled:e,checked:this.item.checked},n={"no-border-icon-box":r};return i`
      <div class="item">
        <edge-accessible-checkbox class=${o(t)} @click="${this.onItemClick}" aria-hidden="true">
          ${c(!e,(()=>i`
            <edge-topsite-favicon class=${o(n)}
                                  .item=${this.item}></edge-topsite-favicon>
          `))}
          <edge-checked-icon .disabled=${e} aria-hidden="true"></edge-checked-icon>
          <edge-unchecked-icon .disabled=${e} aria-hidden="true"></edge-unchecked-icon>
        </edge-accessible-checkbox>
        <div class="title" aria-hidden="true">${this.item.title}</div>
      </div>
    `}});