// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import e from"../../common/i18n.js";import{LitElement as t,html as i,css as r}from"../../common/lit.js";import{sendMessage as a}from"../../common/message.js";import"./edge-icon.js";customElements.define("topsite-navigation-bar",class extends t{static get properties(){return{title:{type:String},hideTabIndex:{type:Boolean}}}static get styles(){return r`
      .bar {
        width: 100%;
        height: auto;
        background: var(--surfaces-primary);
        position: relative;
      }
      .close {
        position: absolute;
        width: 20px;
        height: 20px;
        right: calc(env(safe-area-inset-right) + 20px);
        top: 50%;
        transform: translateY(-50%);
      }

      .title {
        text-align: center;
        font-size: 17rem;
        font-weight: 600;
        width: 100%;
        height: auto;
        line-height: 54rem;
        color: var(--text-primary);
      }

      @media (prefers-color-scheme: dark) {
        .icon-box {
          background: var(--surfaces-quaternary);
        }
        .title {
          color: var(--text-dominant);
        }
        .bar {
          background: var(--surfaces-tertiary);
        }
      }
    `}closePage(){a({action:"close_page",payload:this.title})}render(){return i`
      <div class="bar">
        <div 
          class="title"
          tabindex=${this.hideTabIndex?"-1":"0"}
          role="heading"
          aria-level="1"
          aria-hidden="true"
        >${this.title}</div>
        <edge-cross-icon
          class="close"
          type="square"
          role="button"
          tabindex=${this.hideTabIndex?"-1":"0"}
          aria-label=${e.text("common_close")}
          @click="${this.closePage}"
        ></edge-cross-icon>
      </div>
    `}});