// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{html as e,css as s,classMap as t,LitElement as i}from"../../common/lit.js";import{MixinKeyEvent as r}from"../../common/controls/control-base.js";const n="small",o="round",a=e=>class extends i{static get properties(){return{size:{type:String},type:{type:String},disabled:{type:Boolean}}}static get styles(){return s`
    svg path {
      fill: var(--icon-dominant);
    }
    .large {
      width: 27px;
      height: 27px;
    }

    .middle {
      width: 24px;
      height: 24px;
    }

    .small {
      width: 19px;
      height: 19px;
    }

    .round {
      background: var(--icon-accent);
      border-radius: 50%;
      box-shadow: 0px 0.8px 1.8px rgba(0, 0, 0, 0.13);
    }

    svg.disabled {
      background: var(--surfaces-primary);
      transition: background 100ms;
    }

    svg.disabled path {
        fill: var(--icon-disabled);
        transition: fill 100ms;
    }

    @media (prefers-color-scheme: dark) {
      .round {
        background: var(--surfaces-quaternary);
      }
      svg.disabled {
        background: var(--surfaces-quaternary);
      }
      svg.disabled path {
        fill: var(--icon-secondary);
      }
    }
  `}constructor(){super(),this.size=n,this.type=o,this.disabled=!1}render(){const s={[this.size]:!0,[this.type]:!0,disabled:this.disabled};return e(s)}};customElements.define("edge-checked-icon",a((s=>e`
  <svg class=${t(s)} width="19" height="19" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path d="M13.8536 7.14645C14.0488 7.34171 14.0488 7.65829 13.8536 7.85355L9.35355 12.3536C9.15829 12.5488 8.84171 12.5488 8.64645 12.3536L6.64645 10.3536C6.45118 10.1583 6.45118 9.84171 6.64645 9.64645C6.84171 9.45118 7.15829 9.45118 7.35355 9.64645L9 11.2929L13.1464 7.14645C13.3417 6.95118 13.6583 6.95118 13.8536 7.14645Z" fill="#212121"/>
  </svg>

`))),customElements.define("edge-unchecked-icon",a((s=>e`
  <svg class=${t(s)} width="19" height="19" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path d="M10 5.5C10 5.22386 9.77614 5 9.5 5C9.22386 5 9 5.22386 9 5.5V9H5.5C5.22386 9 5 9.22386 5 9.5C5 9.77614 5.22386 10 5.5 10H9V13.5C9 13.7761 9.22386 14 9.5 14C9.77614 14 10 13.7761 10 13.5V10H13.5C13.7761 10 14 9.77614 14 9.5C14 9.22386 13.7761 9 13.5 9H10V5.5Z"/>
  </svg>
`))),customElements.define("edge-cross-icon",r(a((s=>e`
  <svg class=${t(s)} width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path d="M4.39705 4.55379L4.46967 4.46967C4.73594 4.2034 5.1526 4.1792 5.44621 4.39705L5.53033 4.46967L12 10.939L18.4697 4.46967C18.7626 4.17678 19.2374 4.17678 19.5303 4.46967C19.8232 4.76256 19.8232 5.23744 19.5303 5.53033L13.061 12L19.5303 18.4697C19.7966 18.7359 19.8208 19.1526 19.6029 19.4462L19.5303 19.5303C19.2641 19.7966 18.8474 19.8208 18.5538 19.6029L18.4697 19.5303L12 13.061L5.53033 19.5303C5.23744 19.8232 4.76256 19.8232 4.46967 19.5303C4.17678 19.2374 4.17678 18.7626 4.46967 18.4697L10.939 12L4.46967 5.53033C4.2034 5.26406 4.1792 4.8474 4.39705 4.55379L4.46967 4.46967L4.39705 4.55379Z" fill="#212121"/>
  </svg>
`)))),customElements.define("edge-search-icon",a((s=>e`
  <svg class=${t(s)} width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path d="M10 2.75C14.0041 2.75 17.25 5.99594 17.25 10C17.25 11.7319 16.6427 13.3219 15.6295 14.5688L20.5303 19.4697C20.8232 19.7626 20.8232 20.2374 20.5303 20.5303C20.2641 20.7966 19.8474 20.8208 19.5538 20.6029L19.4697 20.5303L14.5688 15.6295C13.3219 16.6427 11.7319 17.25 10 17.25C5.99594 17.25 2.75 14.0041 2.75 10C2.75 5.99594 5.99594 2.75 10 2.75ZM10 4.25C6.82436 4.25 4.25 6.82436 4.25 10C4.25 13.1756 6.82436 15.75 10 15.75C13.1756 15.75 15.75 13.1756 15.75 10C15.75 6.82436 13.1756 4.25 10 4.25Z" fill="#212121"/>
  </svg>
`)));