// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"../common/dewey/dewey-button.js";import"./components/detail-page.js";import"./components/recommend-item.js";import"./components/installed-item.js";import"./components/kiwi-banner.js";import"./components/kiwi-letter-page.js";import{showPopupMenu as e}from"../common/controls/edge-popupmenu.js";import{EventHub as t}from"../common/event-hub.js";import i from"../common/i18n.js";import{init as n}from"../common/index.js";import{css as s,html as a,LitElement as o,repeat as l,when as r}from"../common/lit.js";import{subscribeMessage as d}from"../common/message.js";import{changeDeveloperModeState as h,closeExtensionHub as c,getInstalledItems as m,getRecommendIds as p,isDeveloperModeEnabled as g,isSettingsEnabled as v,notifyNavigateDetailPage as u,openKiwiLetter as w,showDeveloperModeExplanationDialog as f}from"./action.js";import{DocumentEvent as x,ExtensionModeState as E,ExtensionPage as b,InstallEventType as I,InstallState as y,NativeMessageAction as S}from"./types.js";import{extensionIdInParams as k,getRecommendIdsByIndex as L,loadRecommendCache as _}from"./utils.js";const D=e=>a`
    ${r(e.isShowKiwiBanner(),(()=>a`<kiwi-banner></kiwi-banner>`))}
    ${r(e.installed.length>0,(()=>a`
        <div class="installed-list">
          <div class="section-title" role="heading" aria-level="1">${i.text("extension_installed_title")}</div>
          ${l(e.installed,(e=>e.id),(t=>a`<installed-view
              .item=${t}
              .navigateDetail=${e.navigateDetailPage}
              .eventHub=${e.installEventHub}
              ></installed-view>`))}
        </div>
      `),(()=>a``))}
    ${r(e.recommendIds.length>0,(()=>a`
        <div class="recommend-list">
          <div class="section-title" role="heading" aria-level="1">${i.text("extension_event_title")}</div>
          <div class="section-description" aria-hidden="true">${i.text("extension_event_subtitle")}</div>
          ${l(e.recommendIds,(e=>e),(t=>a`
              <recommend-view
                .extensionId=${t}
                .navigateDetail=${e.navigateDetailPage}
                .eventHub=${e.installEventHub}></recommend-view>`))}
        </div>
      `),(()=>a``))}
    ${r(e.showLoadingView,(()=>a`<div class="loading-container"><div class="loading"></div></div>`),(()=>a``))}
  `,T=e=>a`
    <detail-page
      .inputItem=${e.navigateExtensionItem}
      .eventHub=${e.installEventHub}></detail-page>
  `;var A;!function(e){e[e.HOME=0]="HOME",e[e.DETAIL=1]="DETAIL"}(A||(A={}));const $="extension-hub";customElements.define($,class extends o{static get properties(){return{page:{type:A},isShowKiwiPage:{type:Boolean},installed:{type:Array},recommendIds:{type:Array},settingsEnabled:{type:Boolean},showLoadingView:{type:Boolean},pageIndex:{type:Number},navigateExtensionItem:{type:Object}}}static get styles(){return s`
      :host {
        width: 100%;
        height: auto;
        min-height: 100%;
        display: flex;
        flex-direction: column;
        box-sizing: border-box;
        touch-action: pan-y;
      }
      .detail-overlay {
        position: fixed;
        top: 56px;
        left: 0;
        right: 0;
        bottom: 0;
        background: var(--surfaces-secondary);
        z-index: var(--layer-popups);
        transform: translateX(100%);
        transition: transform 0.3s ease-out;
        overflow-y: auto;
        overscroll-behavior: contain;
      }
      .detail-overlay.visible {
        transform: translateX(0);
      }
      .navigate {
        height: 56px;
        min-height: 56px;
        display: flex;
        align-items: center;
        justify-content: left;
        border-bottom: 1px solid var(--divider-primary);
        background-color: var(--surfaces-primary);
        position: sticky;
        top: 0;
        z-index: calc(var(--layer-popups) + 1);
        padding: 0 16px;
      }
      .navigate-title {
        line-height: 24rem;
        font-size: 20rem;
        font-weight: 500;
        margin-left: 16px;
        color: var(--text-primary);
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
      }
      .tag {
        height: 22px;
        background: var(--surfaces-quaternary);
        padding: 0 8px 0 8px;
        margin-left: 8px;
        color: var(--text-primary);
        display: flex;
        align-items: center;
        justify-content: center;
        border-radius: 4px;
      }
      .navigate-dev-mode {
        position: absolute;
        right: 56px;
        top: 0;
        bottom: 0;
        margin: auto;
        width: 24px;
        height: 24px;
      }
      .navigate-close {
        position: absolute;
        right: 16px;
        top: 0;
        bottom: 0;
        margin: auto;
      }
      .installed-list {
        flex-shrink: 1;
        margin-top: 16px;
        display: flex;
        flex-direction: column;
        padding: 0 16px;
      }
      .recommend-list {
        flex-shrink: 1;
        margin-top: 16px;
        display: flex;
        flex-direction: column;
        padding: 0 16px;
      }
      .section-title {
        font-size: 16rem;
        font-weight: 500;
        line-height: 24rem;
        margin-left: 16px;
        color: var(--icon-dominant);
      }
      .section-description {
        margin-left: 16px;
        font-size: 12rem;
        line-height: 16rem;
        color: var(--text-secondary);
      }
      .floating-btn-icon {
        width: 32px;
        height: 32px;
      }
      .floating-btn {
        width: 64px;
        height: 64px;
        position: fixed;
        bottom: 32px;
        right: 20px;
        box-shadow: 0px 8px 16px 0px rgba(0, 0, 0, 0.14);
        border-radius: 50%;
        background-color: var(--surfaces-secondary);
        display: flex;
        justify-content: center;
        align-items: center;
      }

      .loading-container {
        width: 100%;
        display: flex;
        justify-content: center;
        align-items: center;
      }

      .loading {
        width: 24px;
        height: 24px;
        position: relative;
        margin-top: 12px;
        display: flex;
        justify-content: center;
        align-items: center;
      }

      .loading::after {
        content: '';
        position: absolute;
        width: 100%;
        height: 100%;
        border: 4px solid rgba(0, 120, 255, 0.2);
        border-top-color: #0078D4;
        border-radius: 50%;
        animation: rotate 1s infinite linear;
      }

      @keyframes rotate {
        from { transform: rotate(0deg); }
        to { transform: rotate(360deg); }
      }

      @media (prefers-color-scheme: dark) {
        .floating-btn {
          background-color: var(--surfaces-quaternary);
        }
      }

      @media (orientation: landscape) {
        .floating-btn {
          display: none;
        }
        .wish-container {
          display: none;
        }
      }
    `}constructor(){super(),this.developerModeEnabled=!1,this.settingsEnabled=!1,this.showLoadingView=!1,this.isFetchingData=!1,this.isShowKiwiPage=!1,this.pageIndex=0,this.handleScroll=()=>{this.developSettingsPopup?.dismiss();const e=window.innerHeight+window.scrollY>=document.documentElement.scrollHeight*(this.pageIndex<1?.4:.7);!this.isFetchingData&&this.showLoadingView&&e&&(this.pageIndex++,this.isFetchingData=!0,this.fetchData())},this.handleKiwiBannerClick=()=>{event&&(this.isShowKiwiPage=!0,history.pushState({page:"kiwi"},"",window.location.href),this.requestUpdate())},this.handleKiwiPageClosed=()=>{this.isShowKiwiPage=!1,this.requestUpdate()},this.handleKiwiShowEvent=()=>{event&&"false"!==(localStorage.getItem("kiwi-show-banner")??"default")&&(localStorage.setItem("kiwi-show-banner","true"),w(),this.requestUpdate())},this.handleBackButton=e=>{this.isShowKiwiPage&&(e.preventDefault(),this.handleKiwiPageClosed(),history.pushState(null,"",window.location.href))},this.onTransitionEnd=e=>{"transform"===e.propertyName&&(this.page===A.HOME?(this.navigateExtensionItem=void 0,this.navigateExtensionId=void 0,document.body.style.overflow=""):this.page===A.DETAIL&&(document.body.style.overflow="hidden"))},this.onClickBack=()=>{this.page===A.HOME?c():this.page=A.HOME},this.showSettingsPopup=()=>{const t=this.shadowRoot?.querySelector(".navigate-dev-mode");this.developSettingsPopup=e({target:t,menuOffset:[16,10],placement:"bottomRight",closable:!0,actions:this.getActionList(),zIndex:1e5})},this.onKeyUpClose=e=>{"Enter"===e.key&&this.onClickClose()},this.onClickClose=()=>{c()},this.navigateDetailPage=(e,t)=>{this.navigateExtensionItem=e,this.navigateExtensionItem.installed=t,this.page=A.DETAIL,u(t?b.INSTALLED:b.RECOMMEND)},this.page=A.HOME,this.installEventHub=new t,this.installed=[],this.recommendIds=[],this.fullRecommendIds=[],this.fullRecommendIdsWithoutInstalled=[];const i=k();i&&(this.page=A.DETAIL,this.navigateExtensionId=i),this.fetchData(),this.fetchNavBarStatus(),document.addEventListener(x.CACHE_UPDATE,(e=>{if(e.detail?.extensionId===this.navigateExtensionId){const e=_(this.navigateExtensionId);if(e){const t=JSON.parse(e);this.navigateExtensionItem=t}}})),this.installObserver={onEvent:e=>{switch(e.type){case I.INSTALL_FINISH:if(e.payload?.success&&e.payload?.item){const t=e.payload.item;this.installed.find((e=>e.id===t.id))||(this.installed=[...this.installed,t]),this.recommendIds=this.fullRecommendIds.filter((e=>!this.installed.some((t=>t.id===e))))}this.fetchNavBarStatus();break;case I.UNINSTALLED:this.fetchData(),this.fetchNavBarStatus()}}},d((e=>{if(e.action===S.REFRESH){const t=e.items;if(!t)return;this.installed=t}if(e.action===S.INSTALL_STATE){const t=e.payload;this.notifyInstallState(t.id,t.state,t.error)}if(e.action===S.BACK_PRESS){const e=document.querySelector("edge-tooltip");if(e)return void e.remove();const t=document.querySelector("edge-popupmenu");if(t)return void t.clear();this.page!==A.HOME?this.page=A.HOME:this.isShowKiwiPage?this.handleKiwiPageClosed():c()}}))}isShowKiwiBanner(){return"true"===localStorage.getItem("kiwi-show-banner")}connectedCallback(){super.connectedCallback(),this.installEventHub.register(this.installObserver),document.addEventListener("scroll",this.handleScroll),document.addEventListener("kiwi-show-banner",this.handleKiwiShowEvent),document.addEventListener("kiwi-show-letter",this.handleKiwiBannerClick),document.addEventListener("kiwi-close-letter",this.handleKiwiPageClosed),window.addEventListener("popstate",this.handleBackButton),history.replaceState({page:"home"},"",window.location.href)}disconnectedCallback(){super.disconnectedCallback(),this.installEventHub.unregister(this.installObserver),document.removeEventListener("scroll",this.handleScroll),document.removeEventListener("kiwi-show-banner",this.handleKiwiShowEvent),document.removeEventListener("kiwi-show-letter",this.handleKiwiBannerClick),document.removeEventListener("kiwi-close-letter",this.handleKiwiPageClosed),window.removeEventListener("popstate",this.handleBackButton)}getActionList(){const e=[];return e.push({action:{name:i.text("extension_developer_mode"),type:"switch",payload:{state:this.developerModeEnabled},icon:"./resources/extension_dev_mode_question_mark.svg"},onAction:e=>{h(e?E.DEVELOPER_MODE_ENABLED:E.DEVELOPER_MODE_DISABLED).then((t=>{t&&(this.developerModeEnabled=e)}))},onIcon:()=>{f()}}),e}fetchNavBarStatus(){Promise.all([v(),g()]).then((([e,t])=>{this.settingsEnabled=e,this.developerModeEnabled=t}))}fetchData(){m().then((e=>{this.installed=e,p().then((t=>{this.fullRecommendIds=t,this.fullRecommendIdsWithoutInstalled=t.filter((t=>!e.some((e=>e.id===t)))),this.recommendIds=L(this.pageIndex,this.fullRecommendIdsWithoutInstalled),this.showLoadingView=this.recommendIds.length>0&&this.recommendIds.length!==this.fullRecommendIdsWithoutInstalled.length,this.isFetchingData=!1}))}))}notifyInstallState(e,t,i){switch(t){case y.STATE_PENDING_INSTALL:this.installEventHub?.emit({id:e,type:I.INSTALL_PENDING_START,newState:t});break;case y.STATE_INSTALLING:this.installEventHub?.emit({id:e,type:I.INSTALL_START,newState:t});break;case y.STATE_INSTALLED:{const i=_(e);if(i){const n=JSON.parse(i);this.installEventHub?.emit({id:e,type:I.INSTALL_FINISH,newState:t,payload:{success:!0,item:n}})}else this.fetchData();break}case y.STATE_IDLE:this.installEventHub?.emit({id:e,type:I.INSTALL_FINISH,newState:t,payload:{success:!1,error:i}})}}getNavigationBarTitle(){if(this.page===A.DETAIL){if(this.navigateExtensionItem)return this.navigateExtensionItem.name;if(this.navigateExtensionId){const e=_(this.navigateExtensionId);if(e){return JSON.parse(e).name}}}return i.text("extension_title")}render(){return this.isShowKiwiPage?a`<kiwi-letter-page></kiwi-letter-page>`:a`
      <div class="navigate" tabindex="0">
        ${r(this.page!==A.HOME,(()=>a`
          <img class="navigate-back"
            aria-label="${i.text("common_back")}" role="button"
            @click=${this.onClickBack} src="./resources/extension_back.svg">
        `))}
        <div class="navigate-title">${this.getNavigationBarTitle()}</div>
        ${r(this.page===A.HOME,(()=>a`
          <div class="tag">${i.text("extension_tag_beta")}</div>
          ${r(!!this.settingsEnabled,(()=>a`
            <img class="navigate-dev-mode"
              tabindex="0"
              aria-label="${i.text("extension_developer_mode")}" role="button"
              @click="${this.showSettingsPopup}"
              src="./resources/extension_dev_mode.svg">
          `))}
          <img class="navigate-close"
            tabindex="0"
            aria-label="${i.text("common_close")}" role="button"
            @click=${this.onClickClose}
            @keyup=${this.onKeyUpClose}
            src="./resources/extension_close.svg">
        `))}
      </div>
      <div class="page-container">
        <div class="home-container ${this.page===A.HOME?"visible":"hidden"}">
          ${D(this)}
        </div>
        <div class="detail-overlay ${this.page===A.DETAIL?"visible":"hidden"}"
             @transitionend=${this.onTransitionEnd}>
          ${r(this.page===A.DETAIL,(()=>a`
            ${T(this)}
          `))}
        </div>
      </div>
    `}}),n($);