// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"../../common/dewey/dewey-button.js";import t from"../../common/i18n.js";import{choose as e,css as i,html as n,LitElement as s,when as o}from"../../common/lit.js";import{getInstallState as r,installExtension as a,notifyShowDetailPage as d,openUrl as c,proxyExtensionFetch as l,removeExtensionItem as h,showInstallFailedToast as m}from"../action.js";import{DocumentEvent as p,ExtensionPage as x,InstallEventType as u,InstallState as v}from"../types.js";import{extensionIdInParams as g,getDateStringByTimestamp as I,getExtensionRatingCountString as b,getExtensionRatingString as f,loadRecommendCache as y,saveRecommendCache as S,tryToShowInstalledTooltip as _}from"../utils.js";class E extends s{static get styles(){return i`
      .container {
        display: flex;
        flex-direction: column;
        border-radius: 12px;
        padding: 16px;
        margin: 16px;
        box-sizing: border-box;
        background-color: var(--surfaces-primary);
        border: 1px solid var(--divider-primary);
      }
      .header {
        display: flex;
        justify-content: space-between;
      }
      .info {
        flex: 1;
        display: flex;
        flex-direction: column;
      }
      img {
        width: 48px;
        height: 48px;
        margin: 4px;
        object-fit: contain;
        pointer-events: none;
        margin-inline-end: 16px;
      }
      .title {
        font-size: 16rem;
        line-height: 24rem;
        font-weight: 500;
        color: var(--text-primary);
      }
      .author {
        font-size: 12rem;
        line-height: 16rem;
        font-weight: 400;
        color: var(--accent-primary);
        padding-top: 2px;
      }
      .rating-container {
        display: flex;
        flex-direction: row;
        color: var(--text-secondary);
        align-items: center;
        padding-top: 2px;
      }
      .rating-count {
        margin-left: 8px;
      }
      .desc {
        white-space: pre-line;
        font-size: 12rem;
        line-height: 16rem;
        color: var(--text-primary);
        word-wrap: break-word;
        margin-top: 28px;
        position: relative;
        overflow: hidden;
        transition: max-height 0.3s ease-out;
      }
      .desc:not(.expanded) {
        max-height: 400px;
      }
      .desc.expanded {
        max-height: none;
      }
      .desc:not(.expanded)::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        height: 40px;
        background: linear-gradient(to bottom, transparent, var(--surfaces-primary));
        pointer-events: none;
      }
      .show-more-btn {
        font-size: 12rem;
        line-height: 16rem;
        font-weight: 400;
        color: var(--accent-primary);
        padding-top: 8px;
      }
      .action-container {
        width: 100%;
        height: 36px;
      }
      .action-button {
        margin-top: 16px;
        margin-bottom: 4px;
        width: 100%;
        height: 100%;
        white-space: nowrap;
      }
      .divider {
        margin-top: 16px;
        margin-bottom: 16px;
        border-top: 1px solid var(--divider-primary);
      }
      .footer {
        display: flex;
        flex-direction: row;
      }
      .footer-block {
        flex: 1 1 0;
      }
      .footer-item-title {
        font-size: 12rem;
        line-height: 16rem;
        color: var(--text-secondary);
      }
      .footer-item-content {
        font-size: 12rem;
        line-height: 16rem;
        color: var(--text-primary);
      }
      .policy {
        font-size: 12rem;
        line-height: 16rem;
        color: var(--accent-primary);
      }
    `}constructor(){super(),this.isDescExpanded=!1,this.onGetClick=()=>{this.extensionItem?.id&&a(this.extensionItem.id,x.DETAIL)},this.onRemoveClick=()=>{this.extensionItem?.id&&h(this.extensionItem.id,x.DETAIL).then((t=>{t&&(this.installState=v.STATE_IDLE,this.eventHub?.emit({type:u.UNINSTALLED,id:this.extensionItem.id,newState:v.STATE_IDLE}))}))},this.onAuthorClick=()=>{this.extensionItem?.publisherWebsiteUri&&c(this.extensionItem.publisherWebsiteUri)},this.onPolicyClick=()=>{this.extensionItem?.privacyUrl&&c(this.extensionItem.privacyUrl)},this.installState=v.STATE_IDLE,this.installObserver={onEvent:t=>{switch(t.id===this.extensionItem?.id&&(this.installState=t.newState),t.type){case u.INSTALL_FINISH:if(t.id===this.extensionItem?.id)if(t.payload?.success){const t=this.shadowRoot?.querySelector(".icon");_(t)}else m(t.payload?.error);case u.INSTALL_START:}}}}static get properties(){return{extensionItem:{type:Object},installState:{type:v},isDescExpanded:{type:Boolean}}}connectedCallback(){if(super.connectedCallback(),this.eventHub?.register(this.installObserver),!this.inputItem){const t=g();if(t){const e=y(t);if(e){const t=JSON.parse(e);this.updateExtensionItem(t)}l(t).then((e=>{this.updateExtensionItem(e),S(t,JSON.stringify(this.extensionItem)),document.dispatchEvent(new CustomEvent(p.CACHE_UPDATE,{detail:{extensionId:t}}))})).catch((()=>{}))}return}const t=this.inputItem.id;if(this.inputItem.installed){this.installState=v.STATE_INSTALLED;const e=y(t);if(e){const t=JSON.parse(e);this.updateExtensionItem(t)}l(t).then((e=>{this.updateExtensionItem(e);const i={...this.extensionItem,version:e.version};S(t,JSON.stringify(i))})).catch((()=>{}))}else this.extensionItem=this.inputItem;r(t).then((t=>{t.state!==v.STATE_IDLE&&(this.installState=t.state)})),d()}disconnectedCallback(){super.disconnectedCallback(),this.eventHub?.unregister(this.installObserver)}updateExtensionItem(t){this.extensionItem={id:t.crxId??t.id,name:t.name,description:t.description,iconUrl:t.logoUrl??t.iconUrl,author:t.developer??t.author,rating:t.averageRating??t.rating,ratingCount:t.ratingCount,version:this.inputItem?.installed?this.inputItem.version:t.version,lastUpdateDate:t.lastUpdateDate,privacyUrl:t.privacyUrl,publisherWebsiteUri:t.publisherWebsiteUri}}getDateString(){return this.extensionItem?.lastUpdateDate?I(this.extensionItem.lastUpdateDate):""}getRatingString(){return this.extensionItem?.rating?f(this.extensionItem.rating):"★".repeat(5)}getRatingCountString(){return this.extensionItem?.ratingCount?b(this.extensionItem.ratingCount):""}getShowMoreButtonString(){return this.isDescExpanded?t.text("extension_detail_show_less"):t.text("extension_detail_show_more")}needsTruncation(){return!!this.extensionItem?.description&&this.extensionItem.description.length>E.MAX_DESC_CHARS}render(){return this.extensionItem?n`
      <div class="container">
        <div class="header">
          ${o(null!=this.extensionItem?.iconUrl,(()=>n`<img class="icon" aria-hidden="true" src=${this.extensionItem?.iconUrl} />`))}
          <div class="info">
            <div class="title">${this.extensionItem?.name}</div>
            <div class="author" role="button" @click="${this.onAuthorClick}">
              ${this.extensionItem?.author}
            </div>
            <div class="rating-container">
              <div class="rating">
                ${this.getRatingString()}
              </div>
              <div class="rating-count">
                ${this.getRatingCountString()}
              </div>
            </div>
          </div>
        </div>
        <div class="action-container">
          ${e(this.installState,[[v.STATE_IDLE,()=>n`
              <dewey-button class="action-button" size="medium" type="accent" @click="${this.onGetClick}">${t.text("extension_action_get")}</dewey-button>`],[v.STATE_PENDING_INSTALL,()=>n`
              <dewey-button class="action-button" size="medium" disabled>${t.text("extension_checking")}</dewey-button>`],[v.STATE_INSTALLING,()=>n`
              <dewey-button class="action-button" size="medium" disabled>${t.text("extension_installing")}</dewey-button>`],[v.STATE_INSTALLED,()=>n`
              <dewey-button class="action-button" size="medium" type="outline-accent" @click="${this.onRemoveClick}">${t.text("extension_action_remove")}</dewey-button>`]])}
        </div>
        <div class="desc ${this.isDescExpanded||!this.needsTruncation()?"expanded":""}">
          ${this.extensionItem?.description}
        </div>
        ${o(!!this.extensionItem?.description&&this.needsTruncation(),(()=>n`
          <div 
            class="show-more-btn"
            @click=${()=>this.isDescExpanded=!this.isDescExpanded}>
            ${this.getShowMoreButtonString()}
          </div>
        `))}
        <div class="divider"></div>
        <div class="footer">
          <div class="footer-block">
            <div class="footer-item-title">${t.text("extension_detail_item_version")}</div>
            <div class="footer-item-content">${this.extensionItem?.version}</div>
          </div>
          ${o(this.installState!==v.STATE_INSTALLED,(()=>n`
            <div class="footer-block">
              <div class="footer-item-title">${t.text("extension_detail_item_updated")}</div>
              <div class="footer-item-content">${this.getDateString()}</div>
            </div>`))}
          ${o(""!==this.extensionItem?.privacyUrl,(()=>n`
          <div class="footer-block">
            <div class="footer-item-title">${t.text("extension_detail_item_terms")}</div>
            <div class="policy" role="button" @click="${this.onPolicyClick}">${t.text("extension_detail_item_privacy")}</div>
            </div>
            `))}
        </div>
      </div>
    `:n``}}E.MAX_DESC_CHARS=640,customElements.define("detail-page",E);