// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"../common/dewey/dewey-button.js";import t from"../common/i18n.js";import{css as e,html as r}from"../common/lit.js";import{sendMessage as i}from"../common/message.js";import{commonCss as a,FREBaseElement as o,gradientLabel as n,scaleContainer as l}from"./edge-scfre-common.js";customElements.define("edge-scfre-edge-copilot-dalle3",class extends o{static get properties(){return{isMsaSignedIn:{type:Boolean}}}static get styles(){return e`
    ${a}
    .new-feature-label-container {
      font-size: 13rem;
      font-weight: 400;
    }
    .dalle3-title-container {
      display: flex;
      align-self: flex-start;
      margin-left: 32px;
      margin-right: 32px;
      font-size: 26rem;
      line-height: 31rem;
      font-weight: 700;
      color: var(--text-primary);
      text-align: start;
    }
    .dalle3-image-container {
      display: inline-flex;
      justify-content: center;
      align-items: center;
      height: 700px;
      width: 750px;
    }
    .dalle3-image-container img {
      transform: translateZ(0);
    }
    .dalle3-subtitle-container {
      margin-bottom: 46px;
    }
    .dalle3-subtitle-container-top {
      display: flex;
      justify-content: center;
      margin-bottom: 12px;
    }
    .dalle3-copilot-icon {
      width: 24px;
      height: 24px;
      margin-right: 4px;
    }
    .dalle3-copilot-text {
      color: var(--foreground-solid-colors-neutral-foreground-1, #242424);
      text-align: center;
      font-size: 22rem;
      font-style: normal;
      font-weight: 600;
    }
    .dalle3-subtitle-container-bottom {
      color: var(--text-light-secondary, #6E6E6E);
      text-align: center;
      font-size: 13rem;
      font-style: normal;
      font-weight: 500;
      letter-spacing: -0.078rem;
    }
    .button-portrait {
      display: flex;
      flex-direction: column;
      align-items: center;
      align-self: stretch;
      padding: 0 32px;
    }
    .button-portrait .primary {
      width: 100%;
    }
    .button-portrait .secondary {
      margin-top: 16px;
    }
    .button-landscape {
      display: none;
      align-items: center;
      box-sizing: border-box;
      padding: 12px 32px;
      align-self: stretch;
      border-top: 0.5px solid var(--divider-primary);
    }
    .button-landscape .primary {
      margin-inline-start: 26px;
    }
    .button-landscape > * {
      flex: 1;
    }
    @media (prefers-color-scheme: dark) {
      :host {
        background-color: var(--surfaces-primary);
      }
      .dalle3-title-container{
        color: var(--text-dark-primary, #E1E1E1);
      }
      .dalle3-copilot-text {
        color: var(--text-dark-primary, #E1E1E1);
      }
      .dalle3-subtitle-container-bottom {
        color: var(--text-dark-secondary, #919191);
      }
    }
    @media (orientation: landscape) {
      .dalle3-title-container {
        margin-bottom: 16px;
      }
      .dalle3-subtitle-container {
        margin-bottom: 10px;
      }
      .dalle3-copilot-icon {
        width: 18px;
        height: 18px;
        margin-right: 3px;
      }
      .dalle3-copilot-text {
        font-size: 16.5rem;
      }
      .dalle3-subtitle-container-bottom {
        color: var(--text-light-secondary, #6E6E6E);
        text-align: center;
        font-size: 13rem;
        font-style: normal;
        font-weight: 500;
        letter-spacing: -0.078rem;
      }
      .button-landscape {
        display: flex;
      }
      .button-portrait {
        display: none;
      }
    }
    `}startChat(){i({action:"startChat"}),this.onDismiss()}notNow(){i({action:"notNow"}),this.onDismiss()}renderLabel(){return r`
      <div class="new-feature-label-container page-number-with-icon-container" role="text">
        ${n(t.text(["fre_edge_copilot_dalle3_new_feature_label"]),"new-feature-label")}
      </div>
    `}renderTitle(){return r`
      <div class="dalle3-title-container title" role="heading" aria-level="1">
        ${this.isMsaSignedIn?t.text(["fre_edge_copilot_dalle3_title_signed_in"]):t.text(["fre_edge_copilot_dalle3_title_anonymous"])}
      </div>
    `}renderImageExamples(){return r`
      <div class="dalle3-image-container">
        <picture>
          <source srcset="./resources/dalle3-example-group-dark.jpg" media="(prefers-color-scheme: dark)" />
          <img src="./resources/dalle3-example-group.jpg" aria-hidden="true"/>
        </picture>
      </div>
    `}renderIcon(){return r`
      <div class="dalle3-copilot-icon">
        <svg xmlns="http://www.w3.org/2000/svg" width="100%" height="100%" viewBox="0 0 24 24" fill="none">
        <path d="M17.0722 4.05773C16.7827 3.07218 15.8784 2.39526 14.8512 2.39526L14.1735 2.39526C13.0569 2.39526 12.0994 3.19236 11.897 4.29046L10.7119 10.7199L11.0335 9.61741C11.3216 8.62979 12.2269 7.95082 13.2557 7.95082L17.1772 7.95082L18.8242 8.59235L20.4119 7.95082H19.9483C18.9212 7.95082 18.0168 7.27391 17.7273 6.28836L17.0722 4.05773Z" fill="url(#paint0_radial_145_47919)"/>
        <path d="M7.16561 20.7234C7.45189 21.7137 8.35852 22.3953 9.38937 22.3953H10.8432C12.0912 22.3953 13.1145 21.406 13.1567 20.1587L13.3712 13.8154L12.9681 15.1804C12.6776 16.1644 11.774 16.8398 10.7481 16.8398L6.78679 16.8398L5.37506 16.074L3.84668 16.8398H4.3025C5.33335 16.8398 6.23998 17.5214 6.52626 18.5117L7.16561 20.7234Z" fill="url(#paint1_radial_145_47919)"/>
        <path d="M14.7507 2.39526H6.73041C4.43891 2.39526 3.06401 5.42303 2.14741 8.45079C1.06148 12.0379 -0.359484 16.8354 3.75146 16.8354H7.21482C8.24955 16.8354 9.15794 16.1512 9.44239 15.1563C10.0445 13.0504 11.0997 9.37672 11.9285 6.58015C12.3497 5.15894 12.7005 3.93836 13.239 3.17827C13.5409 2.75213 14.044 2.39526 14.7507 2.39526Z" fill="url(#paint2_linear_145_47919)"/>
        <path d="M14.7507 2.39526H6.73041C4.43891 2.39526 3.06401 5.42303 2.14741 8.45079C1.06148 12.0379 -0.359484 16.8354 3.75146 16.8354H7.21482C8.24955 16.8354 9.15794 16.1512 9.44239 15.1563C10.0445 13.0504 11.0997 9.37672 11.9285 6.58015C12.3497 5.15894 12.7005 3.93836 13.239 3.17827C13.5409 2.75213 14.044 2.39526 14.7507 2.39526Z" fill="url(#paint3_linear_145_47919)"/>
        <path d="M9.24927 22.3952H17.2695C19.561 22.3952 20.9359 19.3674 21.8525 16.3397C22.9384 12.7525 24.3594 7.95508 20.2485 7.95508H16.7851C15.7504 7.95508 14.842 8.63924 14.5575 9.63411C13.9554 11.7401 12.9002 15.4137 12.0714 18.2103C11.6502 19.6315 11.2994 20.8521 10.7609 21.6122C10.4591 22.0383 9.95595 22.3952 9.24927 22.3952Z" fill="url(#paint4_radial_145_47919)"/>
        <path d="M9.24927 22.3952H17.2695C19.561 22.3952 20.9359 19.3674 21.8525 16.3397C22.9384 12.7525 24.3594 7.95508 20.2485 7.95508H16.7851C15.7504 7.95508 14.842 8.63924 14.5575 9.63411C13.9554 11.7401 12.9002 15.4137 12.0714 18.2103C11.6502 19.6315 11.2994 20.8521 10.7609 21.6122C10.4591 22.0383 9.95595 22.3952 9.24927 22.3952Z" fill="url(#paint5_linear_145_47919)"/>
        <defs>
          <radialGradient id="paint0_radial_145_47919" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(18.9994 10.7743) rotate(-128.978) scale(8.73886 8.198)">
            <stop offset="0.0955758" stop-color="#0078D4"/>
            <stop offset="0.715277" stop-color="#0C709B"/>
            <stop offset="1" stop-color="#0A5079"/>
          </radialGradient>
          <radialGradient id="paint1_radial_145_47919" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(5.57463 16.6406) rotate(45.7) scale(8.04078 7.90145)">
            <stop stop-color="#0091EB"/>
            <stop offset="0.523516" stop-color="#2764E7"/>
            <stop offset="0.923392" stop-color="#0636C3"/>
          </radialGradient>
          <linearGradient id="paint2_linear_145_47919" x1="5.16831" y1="2.39526" x2="7.75605" y2="17.6312" gradientUnits="userSpaceOnUse">
            <stop offset="0.289817" stop-color="#00A5D9"/>
            <stop offset="0.662336" stop-color="#21CAB2"/>
            <stop offset="0.950002" stop-color="#6ADC90"/>
          </linearGradient>
          <linearGradient id="paint3_linear_145_47919" x1="7.25046" y1="2.39526" x2="7.87502" y2="16.8354" gradientUnits="userSpaceOnUse">
            <stop stop-color="#10C9EC"/>
            <stop offset="0.166667" stop-color="#01AEE4" stop-opacity="0"/>
          </linearGradient>
          <radialGradient id="paint4_radial_145_47919" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(20.6605 6.54129) rotate(111.466) scale(19.1552 22.9833)">
            <stop offset="0.154405" stop-color="#2771D8"/>
            <stop offset="0.678875" stop-color="#14B1FF"/>
            <stop offset="0.931138" stop-color="#16BFDF"/>
          </radialGradient>
          <linearGradient id="paint5_linear_145_47919" x1="21.2401" y1="7.40461" x2="20.3057" y2="12.9748" gradientUnits="userSpaceOnUse">
            <stop offset="0.0581535" stop-color="#14B1FF"/>
            <stop offset="0.708063" stop-color="#2976DB" stop-opacity="0"/>
          </linearGradient>
        </defs>
        </svg>
      </div>
      `}renderSubtitle(){return r`
      <div class="dalle3-subtitle-container">
        <div class="dalle3-subtitle-container-top">
          ${this.renderIcon()}
          <div class="dalle3-copilot-text">Copilot</div>
        </div>
        <div class="dalle3-subtitle-container-bottom">
          ${t.text(["fre_edge_copilot_dalle3_v2_subtitle"])}
        </div>
      </div>
    `}renderContainer(){return l(r`
      ${this.renderImageExamples()}
    `,{callback:t=>{const e=t.children[0],r=t.offsetWidth/e.offsetWidth,i=t.offsetHeight/e.offsetHeight,a=Math.min(10*Math.min(r,i)/10,1);e.style.transform=`translate(-50%, -50%) scale(${a})`}})}renderButtons(){const e=(e,i)=>r`
      <dewey-button class="primary" size=${e} type=${i} @click=${this.startChat}>
        ${this.isMsaSignedIn?t.text(["fre_edge_copilot_dalle3_create_your_image"]):t.text(["fre_edge_copilot_dalle3_try_it_now"])}
      </dewey-button>
    `,i=(e,i)=>r`
      <dewey-button class="secondary" size=${e} type=${i} @click=${this.notNow}>
        ${t.text(["common_not_now"])}
      </dewey-button>
    `;return r`
      <div class="button-portrait">
        ${e("large","accent")}
        ${i("medium","subtle")}
      </div>
      <div class="button-landscape">
        ${i("medium","outline-accent")}
        ${e("medium","accent")}
      </div>
    `}render(){return r`
    ${this.renderLabel()}
    ${this.renderTitle()}
    ${this.renderContainer()}
    ${this.renderSubtitle()}
    ${this.renderButtons()}
    `}});