// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"../common/controls/control-base.js";import{getOsType as t,urlQuery as e}from"../common/environment.js";import a from"../common/i18n.js";import{classMap as i,css as r,html as o,LitElement as n,ref as s,unsafeCSS as l}from"../common/lit.js";const C=r`
  /*
   * It is an excellent solution to use the media query to adapt the screen size.
   * However, there is a bug in WebKit. When the dom is reused and the screen size changes,
   * the media query will still be in the last state.
  :host {
    --top-margin: max(calc(env(safe-area-inset-top) + 50px), 70px);
    --bottom-margin: max(env(safe-area-inset-bottom), 20px);
    --left-margin: env(safe-area-inset-left);
    --right-margin: env(safe-area-inset-right);
  }

  @media screen and (max-height: 500px) {
    :host {
      --top-margin: 40px;
      --bottom-margin: 20px;
    }
  }
  */

  :host {
    --safe-area-inset-top: max(env(safe-area-inset-top), ${l(e["safe-area-inset-top"]||0)}px);
      --safe-area-inset-bottom: max(env(safe-area-inset-bottom), ${l(e["safe-area-inset-bottom"]||0)}px);  

    --top-max: max(calc(var(--safe-area-inset-top) + 60px), 114px);
    --bottom-max: max(var(--safe-area-inset-bottom), 20px);
    --top-min: 50px;
    --bottom-min: 20px;
    --invalid-value: calc((100vh - 500px) * 1000);

    --top-margin: clamp(var(--top-min), var(--invalid-value), var(--top-max));
    --bottom-margin: clamp(var(--bottom-min), var(--invalid-value), var(--bottom-max));
    --left-margin: env(safe-area-inset-left);
    --right-margin: env(safe-area-inset-right);
  }
`,c=r`
  ${C}
  :host {
    box-sizing: border-box;
    padding: var(--top-margin) var(--right-margin) var(--bottom-margin) var(--left-margin);
    position: absolute;
    width: 100%;
    height: 100%;
    display: flex;
    flex-direction: column;
    align-items: center;
    background-color: #FFFFFF;
    overflow: hidden;
  }
  .page-number {
    position: absolute;
    top: calc(var(--top-margin) - 52px);
    left: calc(var(--left-margin) + 32px);
    right: calc(var(--right-margin) + 32px);
    font-size: 13px;
    white-space: pre-wrap;
    color: var(--text-secondary);
  }
  .page-number-with-icon-container {
    position: absolute;
    display: flex;
    align-items: center;
    flex-direction: row;
    justify-content: between-space;
    top: calc(var(--top-margin) - 52px);
    left: calc(var(--left-margin) + 28px);
    right: calc(var(--right-margin) + 32px);
    height: 40px;
  }
  .page-icon {
    height: 40px;
    object-fit: contain;
    pointer-events: none;
    margin-inline-end: auto;
  }
  .page-number-with-icon {
    font-size: 13px;
    white-space: pre-wrap;
    color: var(--text-secondary);
  }
  .skip-button {
    color: #6E6E6E;
    height: 40px;
    font-weight: 500;
    font-size: 15rem;
    line-height: 20rem;
    display: flex;
    align-items: center;
    justify-content: center;
    box-sizing: border-box;
    padding: 0 20px;
    white-space: nowrap;
  }
  .skip-button:active {
    color: #C7E0F4;
  }
  .bottom-bar {
    align-self: stretch;
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 0 32px 0 16px;
    font-weight: 500;
    font-size: 15rem;
    line-height: 20rem;
  }
  .bottom-bar > * {
    display: flex;
    align-items: center;
    justify-content: center;
    height: 40px;
    padding: 0 16px;
  }
  .bottom-bar-skip {
    color: #0078D4;
  }
  .bottom-bar-next {
    background: #0078D4;
    border-radius: 8px;
    color: white;
  }
  *:focus:not(:focus-visible) {
    outline: none;
  }
  @media screen and (max-height: 500px) {
    .page-number, .page-number-with-icon-container {
      top: 20px;
    }
    :host {
      padding-top: calc(var(--top-margin) + 10px);
    }
  }
  ${"true"===e["tablet-layout"]?r`
  :host {
    --tablet-top-margin: 12vh;
    --tablet-bottom-margin: calc(3vh + var(--bottom-margin));
    --tablet-left-margin: calc(15vw + var(--left-margin));
    --tablet-right-margin: calc(15vw + var(--right-margin));
    padding: var(--tablet-top-margin) var(--tablet-right-margin) var(--tablet-bottom-margin) var(--tablet-left-margin);
  }
  .page-number {
    top: calc(var(--tablet-top-margin) - 52px);
    left: calc(var(--tablet-left-margin) + 32px);
    right: calc(var(--tablet-right-margin) + 32px);
  }
  .page-number-with-icon-container {
      top: calc(var(--tablet-top-margin) - 52px);
      left: calc(var(--tablet-left-margin) + 28px);
      right: calc(var(--tablet-right-margin) + 32px);
  }
  @media (orientation: landscape) {
    :host {;
      --tablet-left-margin: calc(30vw + var(--left-margin));
      --tablet-right-margin: calc(30vw + var(--right-margin));
      padding: var(--tablet-top-margin) var(--tablet-right-margin) var(--tablet-bottom-margin) var(--tablet-left-margin);
    }
  }
`:r``}
`,p="true"===e.voiceover;function d(t="#141414",e="#ACACAC"){return o`
    <svg width="296" height="54" class="toolbar" viewBox="0 0 296 54" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path
        d="M32.2789 13.3103C32.5013 13.5326 32.5013 13.8929 32.2789 14.1153L27.1789 19.2153L32.2789 24.3154C32.5013 24.5377 32.5013 24.8981 32.2789 25.1204C32.0566 25.3427 31.6963 25.3427 31.474 25.1204L25.9714 19.6178C25.7491 19.3955 25.7491 19.0352 25.9714 18.8128L31.474 13.3103C31.6963 13.088 32.0566 13.088 32.2789 13.3103Z"
        fill=${t} />
      <path
        d="M86.1199 13.3103C85.8975 13.5326 85.8975 13.8929 86.1199 14.1153L91.2195 19.2153L86.1199 24.3154C85.8975 24.5377 85.8975 24.8981 86.1199 25.1204C86.3423 25.3427 86.702 25.3427 86.9244 25.1204L92.427 19.6178C92.6494 19.3955 92.6494 19.0352 92.427 18.8128L86.9244 13.3103C86.702 13.088 86.3423 13.088 86.1199 13.3103Z"
        fill=${e} />
      <path
        d="M141.929 10.6769H154.073C158.788 10.6769 162.611 14.4997 162.611 19.2153C162.611 23.931 158.788 27.7538 154.073 27.7538H141.929C137.214 27.7538 133.391 23.931 133.391 19.2153C133.391 14.4997 137.214 10.6769 141.929 10.6769Z"
        stroke=${t} stroke-width="1.5" />
      <path
        d="M144.774 19.2154C144.774 19.949 144.179 20.5436 143.445 20.5436C142.712 20.5436 142.117 19.949 142.117 19.2154C142.117 18.4819 142.712 17.8872 143.445 17.8872C144.179 17.8872 144.774 18.4819 144.774 19.2154ZM149.327 19.2154C149.327 19.949 148.732 20.5436 147.999 20.5436C147.266 20.5436 146.671 19.949 146.671 19.2154C146.671 18.4819 147.266 17.8872 147.999 17.8872C148.732 17.8872 149.327 18.4819 149.327 19.2154ZM152.553 20.5436C153.286 20.5436 153.881 19.949 153.881 19.2154C153.881 18.4819 153.286 17.8872 152.553 17.8872C151.82 17.8872 151.225 18.4819 151.225 19.2154C151.225 19.949 151.82 20.5436 152.553 20.5436Z"
        fill=${t} />
      <path
        d="M205.105 18.094H206.092C206.092 17.4744 206.5 17.0504 207.14 17.0504C207.756 17.0504 208.122 17.4621 208.122 17.9962C208.122 18.4446 207.943 18.7259 207.201 19.476L205.163 21.5264V22.2358H209.248V21.3634H206.59V21.2941L207.854 20.0507C208.865 19.0601 209.162 18.5832 209.162 17.8983C209.162 16.92 208.367 16.2065 207.197 16.2065C205.97 16.2065 205.105 16.9812 205.105 18.094Z"
        fill=${t} />
      <path
        d="M211.943 11.6256C213.464 11.6256 214.706 12.819 214.785 14.3206L214.789 14.4718V23.9589C214.789 25.4802 213.596 26.7226 212.094 26.8012L211.943 26.8051H202.456C200.935 26.8051 199.692 25.6117 199.613 24.1101L199.609 23.9589V14.4718C199.609 12.9506 200.802 11.7081 202.304 11.6296L202.456 11.6256H211.943ZM211.943 12.7641H202.456C201.552 12.7641 200.812 13.4663 200.752 14.3549L200.748 14.4718V23.9589C200.748 24.8628 201.45 25.6026 202.339 25.6627L202.456 25.6666H211.943C212.847 25.6666 213.587 24.9644 213.647 24.0758L213.65 23.9589V14.4718C213.65 13.5679 212.948 12.8281 212.06 12.768L211.943 12.7641Z"
        fill=${t} />
      <path
        d="M272.285 18.4564C272.573 18.4564 272.811 18.6706 272.849 18.9483L272.854 19.0256V24.3391C272.854 25.6544 271.824 26.7293 270.527 26.8018L270.388 26.8058H262.039C260.724 26.8058 259.649 25.7762 259.576 24.4791L259.572 24.3391V19.0256C259.572 18.7112 259.827 18.4564 260.141 18.4564C260.43 18.4564 260.667 18.6706 260.705 18.9483L260.711 19.0256V24.3391C260.711 25.0359 261.247 25.6075 261.93 25.6629L262.039 25.6673H270.388C271.084 25.6673 271.656 25.1306 271.711 24.448L271.716 24.3391V19.0256C271.716 18.7112 271.971 18.4564 272.285 18.4564ZM262.012 15.5846L265.805 11.7923C266.007 11.5904 266.323 11.5719 266.546 11.7369L266.609 11.792L270.408 15.5843C270.631 15.8064 270.631 16.1668 270.409 16.3893C270.206 16.5916 269.891 16.6102 269.667 16.445L269.604 16.39L266.778 13.5693L266.779 22.4447C266.779 22.7329 266.565 22.9711 266.287 23.0088L266.209 23.0139C265.921 23.0139 265.683 22.7998 265.646 22.522L265.64 22.4447L265.639 13.5671L262.818 16.3896C262.616 16.5917 262.299 16.6101 262.076 16.4448L262.012 16.3897C261.81 16.1876 261.792 15.8713 261.958 15.6485L262.012 15.5846L265.805 11.7923L262.012 15.5846Z"
        fill=${t} />
    </svg>
  `}function g(t="rgba(255, 255, 255, 0.15)",e="rgba(0, 0, 0, 0.2)",a="white"){return o`
    <svg class="search" width="186" height="30" viewBox="0 0 186 30" fill="none" xmlns="http://www.w3.org/2000/svg">
      <rect x="1" y="1" width="184" height="28" rx="14" fill=${e} />
      <rect x="0.5" y="0.5" width="185" height="29" rx="14.5" stroke=${t} />
      <path opacity="0.8"
        d="M168.625 15.5C168.815 15.5 168.972 15.6411 168.997 15.8241L169 15.875V16.125C169 17.9047 167.622 19.3627 165.875 19.4908L165.875 20.625C165.875 20.8321 165.707 21 165.5 21C165.31 21 165.153 20.8589 165.128 20.6759L165.125 20.625L165.125 19.4909C163.417 19.3658 162.061 17.969 162.002 16.2432L162 16.125V15.875C162 15.6679 162.168 15.5 162.375 15.5C162.565 15.5 162.722 15.6411 162.747 15.8241L162.75 15.875V16.125C162.75 17.5385 163.867 18.6911 165.267 18.7478L165.375 18.75H165.625C167.039 18.75 168.191 17.6328 168.248 16.2332L168.25 16.125V15.875C168.25 15.6679 168.418 15.5 168.625 15.5ZM165.5 11C166.605 11 167.5 11.8954 167.5 13V16C167.5 17.1046 166.605 18 165.5 18C164.395 18 163.5 17.1046 163.5 16V13C163.5 11.8954 164.395 11 165.5 11ZM165.5 11.75C164.81 11.75 164.25 12.3096 164.25 13V16C164.25 16.6904 164.81 17.25 165.5 17.25C166.19 17.25 166.75 16.6904 166.75 16V13C166.75 12.3096 166.19 11.75 165.5 11.75Z"
        fill=${a} />
      <path opacity="0.8"
        d="M147.962 11C148.361 11 148.73 11.2056 148.932 11.5403L149.34 12.2149H150.375C151.272 12.2149 152 12.9229 152 13.7963V18.4187C152 19.292 151.272 20 150.375 20H143.625C142.728 20 142 19.292 142 18.4187V13.7963C142 12.9229 142.728 12.2149 143.625 12.2149H144.665L145.102 11.5219C145.307 11.1976 145.67 11 146.061 11H147.962ZM147.962 11.7298H146.061C145.949 11.7298 145.845 11.7782 145.774 11.8601L145.742 11.9038L145.195 12.7708C145.126 12.8789 145.005 12.9448 144.875 12.9448H143.625C143.142 12.9448 142.75 13.326 142.75 13.7963V18.4187C142.75 18.8889 143.142 19.2702 143.625 19.2702H150.375C150.858 19.2702 151.25 18.8889 151.25 18.4187V13.7963C151.25 13.326 150.858 12.9448 150.375 12.9448H149.125C148.992 12.9448 148.869 12.8763 148.802 12.7647L148.286 11.9099C148.218 11.7984 148.095 11.7298 147.962 11.7298ZM147 13.6746C148.243 13.6746 149.25 14.6549 149.25 15.8642C149.25 17.0734 148.243 18.0537 147 18.0537C145.757 18.0537 144.75 17.0734 144.75 15.8642C144.75 14.6549 145.757 13.6746 147 13.6746ZM147 14.4045C146.172 14.4045 145.5 15.058 145.5 15.8642C145.5 16.6704 146.172 17.3239 147 17.3239C147.828 17.3239 148.5 16.6704 148.5 15.8642C148.5 15.058 147.828 14.4045 147 14.4045Z"
        fill=${a} />
    </svg>
  `}function h(t){return o`
    <div class="bottom-bar">
      <edge-accessible-button class="bottom-bar-skip" @click=${()=>t(!0)}>
        ${a.text("common_skip")}
      </edge-accessible-button>
      <edge-accessible-button class="bottom-bar-next" @click=${()=>t(!1)}>
        ${a.text("common_next")}
      </edge-accessible-button>
    </div>
  `}function m(t,e={}){const{callback:a,widthRadio:i=.8,heightRadio:r=.8,a11y:n=!1,adjustInstruction:l=!1}=e;let C;const c=t=>{const e=t.children[0],a=t.offsetWidth*i/e.offsetWidth,o=t.offsetHeight*r/e.offsetHeight,n=Math.round(10*Math.min(a,o))/10;e.style.transform=`translate(-50%, -50%) scale(${n})`,!l||window.innerWidth>window.innerHeight||p(t,n)},p=(t,e)=>{const a=t.children[0].querySelector(".bottom-instruction");if(a){const t=15;a.querySelectorAll(".instruction").forEach((a=>{const i=a.querySelector(".instruction-number"),r=a.querySelector(".instruction-text");r&&(r.style.fontSize=`${Math.round(t/e)}px`),i&&(i.style.fontSize=`${Math.round((t-1)/e)}px`,f()&&(i.style.width=i.style.height=`${Math.round(18/e)}px`))}));const i=Math.max(window.innerWidth,375);a.style.minWidth=`${Math.round((i-64)/e)}px`,f()&&(a.style.minHeight="140px",a.style.marginTop="25px")}};return o`
    <style>
      .scale-container {
        flex: 1;
        width: 100%;
        position: relative;
      }
      .scale-container > * {
        position: absolute;
        top: 50%;
        left: 50%;
      }
    </style>
    <div class="scale-container" aria-hidden=${n?"false":"true"} ${s((t=>{C&&C.disconnect(),t&&(C=new ResizeObserver((t=>{const e=t[0]?.target;e&&(a?a(e):c(e))})),C.observe(t))}))}>
      ${t}
    </div>
  `}function f(){const t=window.innerWidth,e=window.innerHeight;return t<=375&&e<=667}function b(){return o`
    <svg class="ms-logo" width="94" height="20" viewBox="0 0 94 20" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M0 0H9.44689V9.50386H0V0Z" fill="#F25022" />
      <path d="M10.4332 0H19.8801V9.50386H10.4332V0Z" fill="#7FBA00" />
      <path d="M0 10.4961H9.44689V20H0V10.4961Z" fill="#00A4EF" />
      <path d="M10.4332 10.4961H19.8801V20H10.4332V10.4961Z" fill="#FFB900" />
      <path
        d="M32.856 11.5194L32.3012 13.1008H32.2549C32.1625 12.7442 31.993 12.2016 31.7156 11.5504L28.7413 4.03102H25.8286V16.0155H27.755V8.62016C27.755 8.15505 27.755 7.62792 27.7396 6.97675C27.7241 6.65117 27.6933 6.40311 27.6779 6.21707H27.7241C27.8166 6.68218 27.9245 7.02327 28.0015 7.24032L31.5769 15.9845H32.933L36.4775 7.1628C36.5546 6.96125 36.6316 6.55815 36.7087 6.21707H36.7549C36.7087 7.10078 36.6779 7.89148 36.6625 8.3721V15.969H38.7121V4.00001H35.9073L32.856 11.5194ZM40.6539 7.37985H42.6573V15.969H40.6539V7.37985ZM41.671 3.75195C41.332 3.75195 41.0546 3.87598 40.8234 4.09304C40.5923 4.31009 40.469 4.58916 40.469 4.93025C40.469 5.25583 40.5923 5.5349 40.8234 5.75195C41.0546 5.969 41.332 6.07753 41.671 6.07753C42.0101 6.07753 42.3029 5.9535 42.5186 5.75195C42.7498 5.5349 42.8731 5.25583 42.8731 4.93025C42.8731 4.60466 42.7498 4.3256 42.5186 4.09304C42.3183 3.87598 42.0255 3.75195 41.671 3.75195ZM49.7617 7.30233C49.3919 7.22482 49.0066 7.1783 48.6368 7.1783C47.7275 7.1783 46.8953 7.37985 46.2018 7.78295C45.5083 8.18605 44.9535 8.74419 44.5991 9.44187C44.2292 10.155 44.0443 10.9767 44.0443 11.9225C44.0443 12.7442 44.2292 13.4729 44.5837 14.1395C44.9381 14.7907 45.4313 15.3178 46.094 15.6744C46.7258 16.031 47.4655 16.217 48.2977 16.217C49.2532 16.217 50.07 16.0155 50.7172 15.6434L50.7326 15.6279V13.7674L50.6556 13.8295C50.3628 14.0465 50.0237 14.2326 49.6847 14.3411C49.3302 14.4651 49.0066 14.5271 48.7292 14.5271C47.9279 14.5271 47.296 14.2946 46.8491 13.7829C46.3868 13.2868 46.1556 12.6047 46.1556 11.7519C46.1556 10.8682 46.3868 10.1705 46.8645 9.65892C47.3422 9.14729 47.9741 8.88373 48.7446 8.88373C49.3919 8.88373 50.0546 9.10078 50.6556 9.53489L50.7326 9.59691V7.62792L50.7172 7.61241C50.4552 7.50389 50.1624 7.37985 49.7617 7.30233ZM56.373 7.24032C55.8799 7.24032 55.4176 7.39536 55.0169 7.72094C54.6778 8.00001 54.4467 8.40311 54.2463 8.88373H54.2309V7.37985H52.2275V15.969H54.2309V11.5814C54.2309 10.8372 54.385 10.2171 54.7241 9.76745C55.0631 9.30233 55.4946 9.06977 56.0186 9.06977C56.2035 9.06977 56.3884 9.11629 56.6196 9.14729C56.8354 9.20931 56.9895 9.27132 57.0973 9.34884L57.1744 9.41086V7.39536L57.1282 7.37985C56.9895 7.28683 56.7121 7.24032 56.373 7.24032ZM61.8285 7.19381C60.4261 7.19381 59.3011 7.61241 58.5151 8.43412C57.7138 9.25582 57.3285 10.3876 57.3285 11.814C57.3285 13.1473 57.7292 14.2326 58.4997 15.0233C59.2703 15.7984 60.3182 16.2015 61.6282 16.2015C62.9997 16.2015 64.0939 15.7829 64.8799 14.9457C65.6812 14.1085 66.0665 12.9922 66.0665 11.6124C66.0665 10.2481 65.6966 9.1628 64.9415 8.3721C64.2172 7.5814 63.1538 7.19381 61.8285 7.19381ZM63.4312 13.7984C63.0614 14.2791 62.4758 14.5116 61.7514 14.5116C61.0271 14.5116 60.4415 14.2791 60.0254 13.7674C59.6093 13.2868 59.409 12.5891 59.409 11.7054C59.409 10.7907 59.6247 10.093 60.0254 9.59691C60.4415 9.10078 61.0117 8.85272 61.736 8.85272C62.4449 8.85272 62.9997 9.08528 63.4004 9.5659C63.8011 10.0465 64.0168 10.7442 64.0168 11.6589C63.986 12.5891 63.8165 13.3178 63.4312 13.7984ZM70.5357 10.9457C69.9038 10.6822 69.5031 10.4806 69.3182 10.3101C69.1641 10.155 69.087 9.93799 69.087 9.65892C69.087 9.42636 69.1795 9.1938 69.4107 9.03877C69.6418 8.88373 69.9038 8.80621 70.2891 8.80621C70.6281 8.80621 70.9826 8.86822 71.3216 8.96125C71.6607 9.05427 71.9689 9.19381 72.2155 9.37985L72.2925 9.44187V7.5504L72.2463 7.53489C72.0151 7.44187 71.7069 7.34885 71.337 7.27133C70.9672 7.20931 70.6281 7.1783 70.3507 7.1783C69.3953 7.1783 68.6093 7.41086 67.9929 7.92249C67.3764 8.40311 67.0836 9.05427 67.0836 9.81396C67.0836 10.2171 67.1453 10.5736 67.284 10.8682C67.4227 11.1628 67.623 11.4419 67.9004 11.6744C68.1778 11.8915 68.5785 12.1395 69.1333 12.3721C69.5956 12.5736 69.95 12.7287 70.1658 12.8527C70.3815 12.9767 70.5202 13.1163 70.6281 13.2248C70.7052 13.3488 70.7514 13.5039 70.7514 13.7054C70.7514 14.2791 70.3199 14.5581 69.4415 14.5581C69.1024 14.5581 68.748 14.4961 68.3319 14.3566C67.9158 14.2171 67.5305 14.0155 67.2069 13.7829L67.1298 13.7209V15.6899L67.1761 15.7054C67.4689 15.845 67.8233 15.938 68.2548 16.0465C68.6864 16.124 69.0716 16.186 69.4107 16.186C70.4432 16.186 71.2908 15.9535 71.8918 15.4419C72.5083 14.9457 72.8319 14.3101 72.8319 13.4884C72.8319 12.9147 72.6778 12.4031 72.3387 12.0155C71.8918 11.6434 71.337 11.2558 70.5357 10.9457ZM78.1178 7.19381C76.7154 7.19381 75.5904 7.61241 74.8045 8.43412C74.0185 9.25582 73.6178 10.3876 73.6178 11.814C73.6178 13.1473 74.0185 14.2326 74.7891 15.0233C75.5596 15.7984 76.6076 16.2015 77.9175 16.2015C79.2891 16.2015 80.3832 15.7829 81.1692 14.9457C81.9706 14.1085 82.3558 12.9922 82.3558 11.6124C82.3558 10.2481 81.986 9.1628 81.2308 8.3721C80.5065 7.5814 79.4432 7.19381 78.1178 7.19381ZM79.7052 13.7984C79.3353 14.2791 78.7497 14.5116 78.0254 14.5116C77.2856 14.5116 76.7154 14.2791 76.2993 13.7674C75.8833 13.2868 75.6829 12.5891 75.6829 11.7054C75.6829 10.7907 75.8987 10.093 76.2993 9.59691C76.7154 9.10078 77.2856 8.85272 78.01 8.85272C78.7034 8.85272 79.2737 9.08528 79.6743 9.5659C80.075 10.0465 80.2908 10.7442 80.2908 11.6589C80.2908 12.5891 80.0904 13.3178 79.7052 13.7984Z"
        fill="#737373" />
      <path
        d="M93.0664 9.03868V7.37977H91.0476V4.83714L90.9859 4.85264L89.075 5.42628L89.0288 5.44179V7.37977H86.0082V6.2945C86.0082 5.79838 86.1315 5.41078 86.3472 5.16272C86.563 4.91466 86.8866 4.79063 87.2873 4.79063C87.5647 4.79063 87.8575 4.85264 88.1812 4.99218L88.2582 5.03869V3.28675L88.212 3.27125C87.9346 3.17823 87.5647 3.11621 87.087 3.11621C86.4859 3.11621 85.962 3.25575 85.4842 3.4883C85.0065 3.75187 84.652 4.10846 84.3901 4.58908C84.1281 5.05419 83.9894 5.58132 83.9894 6.18597V7.37977H82.587V9.02318H83.9894V15.9689H86.0082V9.03868H89.0288V13.4573C89.0288 15.2712 89.8764 16.186 91.5716 16.186C91.8489 16.186 92.1418 16.1394 92.4192 16.0929C92.712 16.0309 92.9277 15.9534 93.051 15.8914L93.0664 15.8759V14.217L92.9894 14.279C92.8661 14.3565 92.7582 14.4185 92.5733 14.465C92.4192 14.5115 92.2804 14.527 92.1726 14.527C91.7719 14.527 91.4945 14.434 91.2942 14.2015C91.1092 13.9844 91.0168 13.6278 91.0168 13.1007V9.03868H93.0664Z"
        fill="#737373" />
    </svg>
  `}function x(){return o`
    <svg class="edge-logo" width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <g clip-path="url(#clip0_2371_7454)">
        <path
          d="M14.4407 11.9083C14.2275 12.02 14.0076 12.1184 13.7823 12.2029C13.0648 12.4713 12.3047 12.6082 11.5386 12.6069C8.58103 12.6069 6.0046 10.5724 6.0046 7.9618C6.00844 7.61187 6.10562 7.2693 6.28609 6.96948C6.46656 6.66965 6.72379 6.42343 7.03122 6.25623C4.35654 6.36836 3.66895 9.15623 3.66895 10.7894C3.66895 15.4064 7.92453 15.875 8.84148 15.875C9.41448 15.8526 9.98225 15.7569 10.5309 15.5901L10.6128 15.5624C12.3348 14.9666 13.8026 13.8023 14.7746 12.2612C14.8039 12.214 14.8168 12.1585 14.8112 12.1033C14.8057 12.048 14.7819 11.9962 14.7438 11.9559C14.7056 11.9156 14.6552 11.889 14.6003 11.8804C14.5455 11.8718 14.4893 11.8816 14.4407 11.9083Z"
          fill="url(#paint0_linear_2371_7454)" />
        <path opacity="0.35"
          d="M14.4407 11.9083C14.2275 12.02 14.0076 12.1184 13.7823 12.2029C13.0648 12.4713 12.3047 12.6082 11.5386 12.6069C8.58103 12.6069 6.0046 10.5724 6.0046 7.9618C6.00844 7.61187 6.10562 7.2693 6.28609 6.96948C6.46656 6.66965 6.72379 6.42343 7.03122 6.25623C4.35654 6.36836 3.66895 9.15623 3.66895 10.7894C3.66895 15.4064 7.92453 15.875 8.84148 15.875C9.41448 15.8526 9.98225 15.7569 10.5309 15.5901L10.6128 15.5624C12.3348 14.9666 13.8026 13.8023 14.7746 12.2612C14.8039 12.214 14.8168 12.1585 14.8112 12.1033C14.8057 12.048 14.7819 11.9962 14.7438 11.9559C14.7056 11.9156 14.6552 11.889 14.6003 11.8804C14.5455 11.8718 14.4893 11.8816 14.4407 11.9083Z"
          fill="url(#paint1_radial_2371_7454)" />
        <path
          d="M6.60729 15.0883C6.04965 14.7417 5.56661 14.2876 5.18635 13.7524C4.75342 13.1579 4.45564 12.4761 4.31383 11.7545C4.17202 11.033 4.18961 10.2891 4.36538 9.5751C4.54115 8.86105 4.87084 8.19404 5.33139 7.62076C5.79193 7.04748 6.3722 6.58177 7.03158 6.25623C7.33036 6.09501 7.6637 6.00845 8.00318 6.00393C8.31511 6.00602 8.62233 6.08024 8.90082 6.22078C9.17931 6.36133 9.42151 6.56438 9.60849 6.81408C9.86097 7.15103 10.0001 7.55937 10.0059 7.98039C10.006 7.96726 11.5349 3.00513 5.0028 3.00513C3.71422 3.0636 2.4922 3.59417 1.56965 4.4957C0.647095 5.39722 0.0885087 6.60669 0.000347118 7.89358C-0.0108255 9.10271 0.247841 10.2991 0.757507 11.3956C1.59009 13.1706 3.04522 14.5782 4.84682 15.3513C6.64842 16.1245 8.67116 16.2095 10.5313 15.5901C9.87983 15.7953 9.19163 15.8567 8.51416 15.7701C7.83669 15.6835 7.18608 15.4509 6.60726 15.0883H6.60729Z"
          fill="url(#paint2_linear_2371_7454)" />
        <path opacity="0.41"
          d="M6.60729 15.0883C6.04965 14.7417 5.56661 14.2876 5.18635 13.7524C4.75342 13.1579 4.45564 12.4761 4.31383 11.7545C4.17202 11.033 4.18961 10.2891 4.36538 9.5751C4.54115 8.86105 4.87084 8.19404 5.33139 7.62076C5.79193 7.04748 6.3722 6.58177 7.03158 6.25623C7.33036 6.09501 7.6637 6.00845 8.00318 6.00393C8.31511 6.00602 8.62233 6.08024 8.90082 6.22078C9.17931 6.36133 9.42151 6.56438 9.60849 6.81408C9.86097 7.15103 10.0001 7.55937 10.0059 7.98039C10.006 7.96726 11.5349 3.00513 5.0028 3.00513C3.71422 3.0636 2.4922 3.59417 1.56965 4.4957C0.647095 5.39722 0.0885087 6.60669 0.000347118 7.89358C-0.0108255 9.10271 0.247841 10.2991 0.757507 11.3956C1.59009 13.1706 3.04522 14.5782 4.84682 15.3513C6.64842 16.1245 8.67116 16.2095 10.5313 15.5901C9.87983 15.7953 9.19163 15.8567 8.51416 15.7701C7.83669 15.6835 7.18608 15.4509 6.60726 15.0883H6.60729Z"
          fill="url(#paint3_radial_2371_7454)" />
        <path
          d="M9.51928 9.30359C9.46861 9.36917 9.31279 9.4597 9.31279 9.65759C9.32183 9.75111 9.3534 9.84105 9.4048 9.9197C9.45619 9.99836 9.52589 10.0634 9.60791 10.1092C10.4107 10.5161 11.3068 10.7033 12.2053 10.6519C12.8715 10.6497 13.525 10.4687 14.0974 10.1277C14.675 9.79053 15.1544 9.30817 15.488 8.72849C15.8216 8.14882 15.9979 7.49198 15.9993 6.82316C16.0065 5.8621 15.7623 4.91585 15.2907 4.07839C14.5676 2.79386 13.5044 1.73356 12.2178 1.01404C10.9313 0.294528 9.47125 -0.0563422 7.99825 1.53203e-07C5.89599 -0.000341366 3.87812 0.827065 2.38127 2.30319C0.884425 3.77932 0.0289669 5.78545 0 7.88751C0.02971 5.60359 2.29963 3.75929 4.99787 3.75929C5.90924 3.76866 6.80671 3.98388 7.6232 4.38888C8.4337 4.7913 9.10522 5.42707 9.55135 6.21436C9.84829 6.78414 10.0043 7.41679 10.0063 8.0593C9.97406 8.51389 9.80417 8.94788 9.51928 9.30359Z"
          fill="url(#paint4_radial_2371_7454)" />
        <path
          d="M9.51928 9.30359C9.46861 9.36917 9.31279 9.4597 9.31279 9.65759C9.32183 9.75111 9.3534 9.84105 9.4048 9.9197C9.45619 9.99836 9.52589 10.0634 9.60791 10.1092C10.4107 10.5161 11.3068 10.7033 12.2053 10.6519C12.8715 10.6497 13.525 10.4687 14.0974 10.1277C14.675 9.79053 15.1544 9.30817 15.488 8.72849C15.8216 8.14882 15.9979 7.49198 15.9993 6.82316C16.0065 5.8621 15.7623 4.91585 15.2907 4.07839C14.5676 2.79386 13.5044 1.73356 12.2178 1.01404C10.9313 0.294528 9.47125 -0.0563422 7.99825 1.53203e-07C5.89599 -0.000341366 3.87812 0.827065 2.38127 2.30319C0.884425 3.77932 0.0289669 5.78545 0 7.88751C0.02971 5.60359 2.29963 3.75929 4.99787 3.75929C5.90924 3.76866 6.80671 3.98388 7.6232 4.38888C8.4337 4.7913 9.10522 5.42707 9.55135 6.21436C9.84829 6.78414 10.0043 7.41679 10.0063 8.0593C9.97406 8.51389 9.80417 8.94788 9.51928 9.30359Z"
          fill="url(#paint5_radial_2371_7454)" />
      </g>
      <defs>
        <linearGradient id="paint0_linear_2371_7454" x1="3.66895" y1="11.0656" x2="14.8149" y2="11.0656"
          gradientUnits="userSpaceOnUse">
          <stop stop-color="#0C59A4" />
          <stop offset="1" stop-color="#114A8B" />
        </linearGradient>
        <radialGradient id="paint1_radial_2371_7454" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse"
          gradientTransform="translate(9.82434 11.1486) scale(5.96144 5.66974)">
          <stop offset="0.71659" stop-opacity="0" />
          <stop offset="0.9459" stop-opacity="0.53" />
          <stop offset="1" />
        </radialGradient>
        <linearGradient id="paint2_linear_2371_7454" x1="9.54555" y1="6.2302" x2="2.58335" y2="13.8137"
          gradientUnits="userSpaceOnUse">
          <stop stop-color="#1B9DE2" />
          <stop offset="0.16164" stop-color="#1595DF" />
          <stop offset="0.66749" stop-color="#0680D7" />
          <stop offset="1" stop-color="#0078D4" />
        </linearGradient>
        <radialGradient id="paint3_radial_2371_7454" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse"
          gradientTransform="translate(4.45834 12.4225) rotate(-81.4635) scale(8.95222 7.21386)">
          <stop offset="0.76293" stop-opacity="0" />
          <stop offset="0.9459" stop-opacity="0.5" />
          <stop offset="1" />
        </radialGradient>
        <radialGradient id="paint4_radial_2371_7454" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse"
          gradientTransform="translate(1.56945 2.93263) rotate(92.1285) scale(12.6518 26.9464)">
          <stop stop-color="#35C1F1" />
          <stop offset="0.11079" stop-color="#34C1ED" />
          <stop offset="0.23164" stop-color="#2FC2DF" />
          <stop offset="0.31446" stop-color="#2BC3D2" />
          <stop offset="0.67338" stop-color="#36C752" />
        </radialGradient>
        <radialGradient id="paint5_radial_2371_7454" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse"
          gradientTransform="translate(15.159 4.84336) rotate(73.674) scale(6.08357 4.96703)">
          <stop stop-color="#66EB6E" />
          <stop offset="1" stop-color="#66EB6E" stop-opacity="0" />
        </radialGradient>
        <clipPath id="clip0_2371_7454">
          <rect width="16" height="16" fill="white" />
        </clipPath>
      </defs>
    </svg>
  `}function u(t,e){const a={"tag-wrap":!0};e&&(a[e]=!0);Math.random();return o`
    <div class=${i(a)} tabindex="0">
      <div class="tag-title">${t}</div>
    </div>
    <style>
      .tag-wrap {
        padding: 4px 8px;
        display: inline-block;
        position: relative;
        border: 1px solid #C8C8C8;
        border-radius: 4px;
      }
      .tag-title {
        font-size: 13rem;
        line-height: 18rem;
        color: #6E6E6E;
      }
    </style>
  `}function v(t,e){return o`
  <div class=${e}>
    <div class="gradient-label">${t}</div>
  </div>
  <style>
    .gradient-label {
      --r:4px; /* radius */
      --b:1px; /* border width */

      background: linear-gradient(90deg, #5D00D4 0.01%, #38C3FF 99.98%);
      background-clip: text;
      color: transparent;
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;

      border-radius: var(--r);
      position: relative;
      padding: 4px 8px;
    }
    .gradient-label:before {
      content: "";
      position: absolute;
      inset: 0;
      border: var(--b) solid transparent;
      border-radius: var(--r);
      background: inherit;
      background-origin: border-box;
      background-clip: border-box;
      -webkit-mask: /*4*/
        linear-gradient(#fff 0 0) padding-box,
        linear-gradient(#fff 0 0);
      -webkit-mask-composite: xor;
        mask-composite: exclude;
      -webkit-mask-repeat: no-repeat;
    }
    @media (prefers-color-scheme: dark) {
      .gradient-label {
        background: linear-gradient(90deg, #B696FF 0.01%, #69A1FA 51.03%, #4CB4B7 99.98%);
        background-clip: text;
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
      }
    }
  </style>
  `}class w extends n{static get shadowRootOptions(){return{...n.shadowRootOptions,delegatesFocus:!0}}firstUpdated(){if(super.firstUpdated(),!p)return;const e=()=>{const t=this.shadowRoot.querySelector(".page-number")??this.shadowRoot.querySelector(".title");t?.focus()};if("iOS"===t()){let t=0;this.ariaTimer=setInterval((()=>{++t>10&&e(),t>20&&(clearInterval(this.ariaTimer),this.ariaTimer=null)}),100)}else setTimeout((()=>{e()}),500)}disconnectedCallback(){super.disconnectedCallback(),this.ariaTimer&&(clearInterval(this.ariaTimer),this.ariaTimer=null)}}export{C as constantCss,c as commonCss,p as voiceoverEnable,d as toolbarSVG,m as scaleContainer,g as searchSVG,h as bottomBar,b as msLogo,x as edgeLogo,u as colorTag,v as gradientLabel,w as FREBaseElement};