// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import t from"../../common/i18n.js";import e from"../../common/animation.js";import{html as i,css as o,repeat as r,when as a}from"../../common/lit.js";import{commonCss as s,voiceoverEnable as n,bottomBar as l,searchSVG as p,scaleContainer as g,colorTag as c,FREBaseElement as h}from"../edge-fre-common.js";customElements.define("edge-fre-wallpaper",class extends h{static get properties(){return{imageTargetSrc:{type:String},imageMaskSrc:{type:String},showPhoneList:{type:Boolean}}}constructor(){super(),this.imageTargetSrc="wallpaper_0.jpg",this.imageMaskSrc="wallpaper_1.jpg",this.showPhoneList=!1}static get styles(){return o`
    ${s}
    .bg {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        filter: blur(45px);
        transform: translateZ(0);
    }
    .head {
        position: relative;
        align-self: flex-start;
        margin-left: 32px;
        margin-right: 32px;
        will-change: opacity;
    }
    .title {
        font-size: 26rem;
        line-height: 31rem;
        font-weight: 700;
        white-space: pre-wrap;
        text-align: start;
        margin-bottom: 12px;
        color: #212121;
    }
    .top-button {
      border-color: rgba(64, 64, 64, 0.5);
    }
    .tag-title {
      color: #404040;
    }
    .phone-container {
      width: 100%;
      height: 430px;
    }
    .phone-content {
      position: absolute;
      bottom: 0;
      left: 0;
      right: 0;
      display: flex;
      flex-direction: column;
      align-items: center;
      transform-origin: center bottom;
      opacity: 0;
      transform: scale(0.5);
    }
    .phone {
        position: relative;
        overflow: hidden;
        display: flex;
        box-sizing: border-box;
        flex-direction: column;
        justify-content: flex-end;
        align-items: center;

        width: 216px;
        height: 408px;
        border-radius: 30px;
        border: 4px solid #ECECEC;
        will-change: opacity, transform;
    }
    .phone > * {
        position: relative;
        will-change: opacity, transform;
    }
    .phone > .dot {
        width: 35px;
        height: 17px;
        margin-top: 80px;
        margin-bottom: 6px;
    }
    .phone > .search {
        width: 186px;
        height: 30px;
    }
    .phone-bg {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        width: 100%;
        height: 100%;
        object-fit: cover;
        pointer-events: none;
    }
    .phone-container > .phone {
        position: absolute;
        left: 0;
        right: 0;
        bottom: 0;
        margin: auto;
        border-color: rgba(241, 241, 241, 0.3);
        transform-origin: center bottom;
    }
    .phone-list {
        display: flex;
    }
    .phone-list:first-child {
        margin-top: auto;
        margin-bottom: 8px;
        transform: translateX(80px);
    }
    .phone-list > .phone {
        margin-inline-start: 8px;
    }
    .phone-list > .phone:first-child {
        margin-inline-start: 0;
    }
    .footer {
        align-self: stretch;
        position: relative;
        margin: 0 32px;
        height: 52px;
    }
    .bottom-bar {
      position: relative;
    }
    .bottom-bar-skip {
      color: white;
    }
    .start-button {
        position: absolute;
        width: 100%;
        height: 52px;
        background-color: #0078D4;
        color: #FFFFFF;
        font-weight: 500;
        font-size: 15rem;
        line-height: 20rem;
        border-radius: 8px;
        box-sizing: border-box;
        padding: 0 20px;
        bottom: 0px;
        opacity: 0;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    .start-button:active {
      background-color: #2B88D8;
    }
    .skip-button {
        position: absolute;
        bottom: 0px;
        left: 50%;
        transform: translateX(-50%);
        opacity: 1.0;
        color: #000000;
    }
    `}createAnimation(){const t=t=>()=>this.renderRoot.querySelector(t),i=t=>()=>this.renderRoot.querySelectorAll(t);return e({duration:500}).delay(1e3).add([{targets:i(".img-mask"),duration:1e3,opacity:1},{targets:i(".img-target"),duration:1e3,opacity:0}]).add((()=>{this.imageTargetSrc="wallpaper_2.jpg"})).delay(400).add([{targets:i(".img-mask"),duration:500,opacity:0},{targets:i(".img-target"),duration:500,opacity:1},{targets:i(".skip-button"),color:"#FFFFFF"}]).add((()=>{this.showPhoneList=!0})).delay(500).add([{targets:t(".start-button"),opacity:1},{targets:i(".bg"),opacity:0},{targets:t(".skip-button"),opacity:0},{targets:t(".phone-container > .phone"),transform:"scale(0.5)",borderColor:"#ECECEC"},{targets:t(".phone-content"),opacity:1}]).add((()=>{t(".phone-container > .phone")().remove();t(".skip-button")().remove()})).add([{targets:t(".list-first"),duration:2e3,transform:"translateX(0)"},{targets:t(".list-last"),duration:2e3,transform:"translateX(80px)"}])}render(){return i`
        <style>
        .bg.img-target {
            background: linear-gradient(0deg, rgba(255, 255, 255, 0.2), rgba(255, 255, 255, 0.2)), url('./resources/${this.imageTargetSrc}'), #FFFFFF;
        }
        .bg.img-mask {
            background: linear-gradient(0deg, rgba(255, 255, 255, 0.2), rgba(255, 255, 255, 0.2)), url('./resources/${this.imageMaskSrc}'), #FFFFFF;
        }
        .img-mask {
            opacity: 0;
        }
        </style>
        <div class="bg img-target"></div>
        <div class="bg img-mask"></div>
        <div class="head">
            <div class="title" role="heading" aria-level="1" tabindex="0">${t.text(["fre_wallpaper_title"])}</div>
            ${c(t.text("fre_wallpaper_tag_title"),"top-button")}
        </div>
        ${this.renderPhone()}
        ${a(n,(()=>l(this.onNext)),(()=>i`
            <div class="footer">
              <edge-accessible-button class="start-button" @click="${()=>this.onNext(!1)}">${t.text(["fre_wallpaper_start"])}</edge-accessible-button>
              <edge-accessible-button class="skip-button" @click="${()=>this.onNext(!0)}">${t.text(["fre_common_skip"])}</edge-accessible-button>
            </div>
          `))}
    `}renderPhone(){return g(i`
      <div class="phone-container">
        <div class="phone-content">
          ${this.showPhoneList?i`
          <div class="phone-list list-first">
            ${r(["wallpaper_3.jpg","wallpaper_0.jpg","wallpaper_1.jpg","wallpaper_4.jpg","wallpaper_5.jpg"],(t=>t),(t=>this.phoneHTML(t)))}
          </div>
          <div class="phone-list list-last">
            ${r(["wallpaper_4.jpg","wallpaper_5.jpg","wallpaper_2.jpg","wallpaper_3.jpg","wallpaper_0.jpg"],(t=>t),(t=>this.phoneHTML(t)))}
          </div>
          `:null}
        </div>
        ${this.phoneHTML(this.imageTargetSrc,this.imageMaskSrc)}
      </div>
    `,{widthRadio:2,heightRadio:.8})}phoneHTML(t,e){return i`
        <div class="phone">
          <img class="phone-bg img-target" src="./resources/${t}">
          ${e?i`<img class="phone-bg img-mask" src="./resources/${e}">`:null}
          ${p()}
          <svg class="dot" width="35" height="17" viewBox="0 0 35 17" fill="none" xmlns="http://www.w3.org/2000/svg">
            <rect width="35" height="17" rx="8.5" fill="black" fill-opacity="0.19" />
            <circle cx="10.748" cy="8.70996" r="2" fill="white" fill-opacity="0.41" />
            <circle cx="17.748" cy="8.70996" r="2" fill="white" fill-opacity="0.41" />
            <circle cx="24.748" cy="8.70996" r="2" fill="white" fill-opacity="0.41" />
          </svg>
        </div>
        `}});