// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import e from"../../common/animation.js";import i from"../../common/i18n.js";import{css as t,html as r}from"../../common/lit.js";import{commonCss as n,FREBaseElement as o,scaleContainer as s}from"../edge-fre-common.js";customElements.define("edge-fre-ending-default",class extends o{static get styles(){return t`
      ${n}
      :host {
        padding-bottom: 20vh;
      }
      .page-number {
        position: absolute;
        top: 68px;
        left: 32px;
        right: 32px;
        font-size: 13px;
        white-space: pre-wrap;
        color: var(--text-secondary);
      }
      .title {
        align-self: flex-start;
        margin-left: 32px;
        margin-right: 32px;
        font-size: 26rem;
        line-height: 31rem;
        font-weight: 700;
        color: var(--text-primary);
        white-space: pre-wrap;
        text-align: start;
      }
      .subtitle {
        align-self: flex-start;
        margin: 8px 32px 0;
        font-size: 15rem;
        line-height: 20rem;
        color: var(--text-secondary);
      }
      .phone {
        width: 262px;
        height: 278px;
      }
      .phone-img {
        width: 168px;
        height: 250px;
        position: absolute;
        top: 20px;
        left: 54px;
        pointer-events: none;
        background-size: contain;
        background-image: url("./resources/ending-phone.png");
      }
      .finish {
        position: absolute;
        width: 60px;
        height: 60px;
        top: 15px;
        right: 60px;
        transform: scale(0.7);
        transform-origin: 30% 70%;
        pointer-events: none;
        background-size: contain;
        background-image: url("./resources/ending-finish.png");
      }
      .fireworks {
        --width: 261px;
        position: absolute;
        width: var(--width);
        height: 252px;
        top: 30px;
        left: calc(50% - var(--width) / 2);
        transform: scale(0.7);
        pointer-events: none;
      }
      .cloud {
        --width: 228px;
        position: absolute;
        width: var(--width);
        height: 207px;
        top: 50px;
        left: calc(50% - var(--width) / 2);
        transform: scale(0.5);
        pointer-events: none;
      }
      @media screen and (max-height: 700px) {
        :host {
          padding-bottom: 10vh;
        }
      }
      @media (prefers-color-scheme: dark) {
        :host {
          background-color: var(--surfaces-primary);
        }
        .phone-img {
          background-image: url("./resources/ending-phone-dark.png");
        }
        .finish {
          background-image: url("./resources/ending-finish-dark.png");
        }
      }
    `}firstUpdated(){super.firstUpdated();const i=e=>()=>this.renderRoot.querySelector(e);e({easing:"cubic-bezier(.5,0.5,.5,2.0)",duration:200}).delay(300).add({targets:[i(".finish"),i(".fireworks"),i(".cloud")],transform:"scale(1.0)"}).delay(1e3).add((()=>{this.onNext(!1)})).run()}render(){return r`
      <div class="title" role="heading" aria-level="1" tabindex="0">${i.text(["fre_ending_title"])}</div>
      <div class="subtitle" tabindex="0">${i.text(["fre_ending_subtitle"])}</div>
      ${this.renderPhone()}
    `}renderPhone(){return s(r`
    <div class="phone">
      <img class="cloud" src='./resources/ending-cloud.png' />
      <img class="fireworks" src='./resources/ending-fireworks.png' />
      <div class="phone-img"></div>
      <div class="finish"></div>
    </div>
    `,{widthRadio:.7,heightRadio:.7})}});