// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import t from"../../common/i18n.js";import e from"../../common/animation.js";import{html as o,css as r,when as i}from"../../common/lit.js";import{commonCss as a,voiceoverEnable as l,bottomBar as s,scaleContainer as n,colorTag as d,FREBaseElement as c}from"../edge-fre-common.js";import"./edge-fre-dark-article.js";customElements.define("edge-fre-dark",class extends c{static get styles(){return r`
        ${a}
        .head {
          align-self: flex-start;
          margin-inline-start: 32px;
          margin-inline-end: 32px;
        }
        .title {
          font-size: 26rem;
          line-height: 31rem;
          font-weight: 700;
          white-space: pre-wrap;
          text-align: start;
          margin-bottom: 12px;
          color: #212121;
        }
        .phone {
          width: 305px;
          height: 449px;
        }
        .phone-content {
          width: 100%;
          height: 100%;
          box-sizing: border-box;
          border: 5px solid #F1F1F1;
          border-bottom-width: 0;
          border-top-right-radius: 33px;
          border-top-left-radius: 33px;
          display: flex;
          flex-direction: column;
          align-items: center;
          overflow: hidden;
        }
        .tool-bar {
          position: relative;
          width: 100%;
          height: 67px;
          background-color: #F8F8F8;
          border-bottom: 1px solid rgba(189, 189, 189, 0.25);
        }
        .search {
          position: absolute;
          left: 0;
          right: 0;
          bottom: 0;
        }
        .search-button-bg {
          opacity: 0;
        }
        .dark-button-bg {
          opacity: 0;
        }
        .button-select {
          opacity: 0;
        }
        .tool-text {
          position: absolute;
          top: 0;
          left: 0;
          right: 0;
          bottom: 0;
          margin: auto;
          transform: translateY(-60px);
        }
        .touch-bg {
          box-sizing: border-box;
          width: 24px;
          height: 24px;
          border-radius: 50%;
          background: rgba(255, 255, 255, 0.5);
          border: 2px solid #FFFFFF;
          box-shadow: 0px 4px 18px rgba(55, 55, 55, 0.22);
          position: absolute;
          bottom: -4px;
          right: 50px;
          transform: scale(1.4);
          z-index: 99;
          will-change: opacity;
        }
        .phone-color-mask {
          position: absolute;
          left: 0;
          top: 0;
          width: 100%;
          height: 100%;
          border-top-right-radius: 33px;
          border-top-left-radius: 33px;
          background-color: rgba(10, 10, 10, 0.9);
          opacity: 0;
          will-change: opacity;
        }
        .phone-light-mask {
          position: absolute;
          bottom: 0;
          left: 0;
          opacity: 0;
          will-change: opacity;
        }
    `}render(){return o`
        <div class="head">
          <div class="title" role="heading" aria-level="1" tabindex="0">${t.text(["fre_dark_title"])}</div>
          ${d(t.text("fre_dark_tag_title1"),"top-button")}
        </div>
        ${this.renderPhone()}
        ${i(l,(()=>s(this.onNext)),(()=>o`
            <edge-accessible-button class="skip-button" @click="${()=>this.onNext(!0)}">${t.text(["fre_common_skip"])}</edge-accessible-button>
          `))}
        `}renderPhone(){return n(o`
      <div class="phone">
        <div class="phone-content">
          <div class="tool-bar">
            ${this.toolSVG()}
            ${this.searchSVG()}
            <div class="touch-bg"></div>
          </div>
          <edge-fre-dark-article></edge-fre-dark-article>
          <div class="phone-color-mask"></div>
        </div>
        ${this.lightMaskSVG()}
      </div>
    `)}createAnimation(){const o=t=>()=>this.renderRoot.querySelector(t),r=o("edge-fre-dark-article")();return e({duration:200}).delay(1e3).add([{targets:o(".touch-bg"),transform:"scale(1.0)"},{targets:o(".search-button-bg"),opacity:1}]).delay(200).add([...r.scaleAnimation(),{targets:[o(".touch-bg"),o(".search-button-bg")],duration:300,opacity:0},{targets:o(".search"),duration:200,opacity:0},{targets:o(".tool-text"),duration:500,transform:"translateY(0px)"}]).add({targets:o(".touch-bg"),duration:10,transform:"scale(1.4) translate(12px, -10px)"}).delay(500).add({targets:o(".touch-bg"),duration:50,opacity:1}).delay(300).add([{targets:o(".touch-bg"),transform:"scale(1) translate(12px, -10px)"},{targets:o(".dark-button-bg"),opacity:1}]).delay(200).add({targets:[o(".dark-button-bg"),o(".touch-bg")],duration:100,opacity:0}).add([...r.darkAnimation(200),{targets:this,backgroundColor:"#141414"},{targets:o(".tool-bar"),backgroundColor:"#212121"},{targets:o(".tool-text"),fill:"#FFFFFF"},{targets:[o(".button-select"),o(".phone-color-mask")],opacity:1},{targets:o(".phone-content"),borderColor:"#2F2F2F"},{targets:[o(".dark-button-bg"),o(".top-button")],opacity:0},{targets:o(".skip-button"),color:"rgba(64, 64, 64, 0.3)"}]).add((()=>{const e=o(".tag-title")();e.style.color="#919191",e.textContent=t.text("fre_dark_tag_title2"),e.parentElement.style.borderColor="#404040"})).delay(500).add([{targets:o(".phone-color-mask"),duration:50,opacity:0},{targets:[o(".phone-light-mask"),o(".top-button")],duration:50,opacity:1},{targets:o(".title"),duration:50,color:"#FFFFFF"},{targets:o(".skip-button"),color:"#919191"}])}searchSVG(){return o`
    <svg class="search" width="295" height="39" viewBox="0 0 295 39" fill="none" xmlns="http://www.w3.org/2000/svg">
      <g>
        <path
          d="M273 14.0002C270.239 14.0002 268 16.2388 268 19.0002C268 21.7617 270.239 24.0002 273 24.0002C275.761 24.0002 278 21.7617 278 19.0002C278 18.7493 277.982 18.5028 277.946 18.2618C277.901 17.9591 278.123 17.6669 278.429 17.6669C278.676 17.6669 278.893 17.8377 278.93 18.0821C278.976 18.3814 279 18.6881 279 19.0002C279 22.314 276.314 25.0002 273 25.0002C269.686 25.0002 267 22.314 267 19.0002C267 15.6865 269.686 13.0002 273 13.0002C274.537 13.0002 275.938 13.578 277 14.528V13.8336C277 13.5574 277.224 13.3336 277.5 13.3336C277.776 13.3336 278 13.5574 278 13.8336V15.8336C278 16.1097 277.776 16.3336 277.5 16.3336H275.5C275.224 16.3336 275 16.1097 275 15.8336C275 15.5574 275.224 15.3336 275.5 15.3336H276.399C275.507 14.5061 274.313 14.0002 273 14.0002Z"
          fill="#212121" />
        <path
          d="M21 4.75024C13.1299 4.75024 6.75 11.1302 6.75 19.0002C6.75 26.8703 13.1299 33.2502 21 33.2502H237C244.87 33.2502 251.25 26.8703 251.25 19.0002C251.25 11.1302 244.87 4.75024 237 4.75024H21Z"
          fill="white" stroke="#E1E1E1" stroke-width="0.5" />
        <circle class="search-button-bg" cx="224" cy="19.0002" r="13.5" fill="#F3EFE0" stroke="white" />
        <path
          d="M224 24.1433C223.601 24.6637 222.966 25.0002 222.25 25.0002H218.312C217.588 25.0002 217 24.4246 217 23.7145V14.286C217 13.5759 217.588 13.0002 218.312 13.0002H222.25C222.966 13.0002 223.601 13.3368 224 13.8572C224.399 13.3368 225.034 13.0002 225.75 13.0002H229.687C230.412 13.0002 231 13.5759 231 14.286L231 23.7145C231 24.4246 230.412 25.0002 229.687 25.0002L225.75 25.0002C225.034 25.0002 224.399 24.6637 224 24.1433ZM217.875 14.286V23.7145C217.875 23.9512 218.071 24.1431 218.312 24.1431H222.25C222.975 24.1431 223.562 23.5675 223.562 22.8574V15.1431C223.562 14.433 222.975 13.8574 222.25 13.8574H218.312C218.071 13.8574 217.875 14.0493 217.875 14.286ZM224.437 22.8574C224.437 23.5675 225.025 24.1431 225.75 24.1431L229.687 24.1431C229.929 24.1431 230.125 23.9512 230.125 23.7145L230.125 14.286C230.125 14.0493 229.929 13.8574 229.687 13.8574L225.75 13.8574C225.025 13.8574 224.438 14.433 224.437 15.1431V22.8574Z"
          fill="#212121" />
        <path
          d="M25.5 13.0002C26.7426 13.0002 27.75 14.0748 27.75 15.4002V16.2002H28.5C29.3284 16.2002 30 16.9166 30 17.8002V23.4002C30 24.2839 29.3284 25.0002 28.5 25.0002H22.5C21.6716 25.0002 21 24.2839 21 23.4002V17.8002C21 16.9166 21.6716 16.2002 22.5 16.2002H23.25V15.4002C23.25 14.0748 24.2574 13.0002 25.5 13.0002ZM25.5 19.8002C25.0858 19.8002 24.75 20.1584 24.75 20.6002C24.75 21.0421 25.0858 21.4002 25.5 21.4002C25.9142 21.4002 26.25 21.0421 26.25 20.6002C26.25 20.1584 25.9142 19.8002 25.5 19.8002ZM25.5 14.6002C25.0858 14.6002 24.75 14.9584 24.75 15.4002V16.2002H26.25V15.4002C26.25 14.9584 25.9142 14.6002 25.5 14.6002Z"
          fill="#6E6E6E" />
        <circle cx="25.5" cy="20.5002" r="1.5" fill="white" />
      </g>
    </svg>
    `}toolSVG(){return o`
        <svg class="tool-text" width="294" height="44" viewBox="0 0 294 44" fill="#212121" xmlns="http://www.w3.org/2000/svg">
          <circle class="dark-button-bg" cx="232" cy="22" r="21.5" fill="#F3EFE0" stroke="white" />
          <g>
            <path
              d="M110.049 28.9791L115.549 14.4839C115.779 13.8766 116.602 13.8409 116.902 14.3768L116.951 14.484L122.451 28.9845C122.598 29.3718 122.403 29.8048 122.016 29.9517C121.661 30.0864 121.268 29.9338 121.091 29.6092L121.049 29.5164L119.335 24.9995H113.163L111.451 29.5112C111.317 29.8662 110.942 30.0595 110.582 29.9761L110.484 29.9463C110.129 29.8116 109.936 29.4365 110.019 29.0766L110.049 28.9791L115.549 14.4839L110.049 28.9791ZM116.25 16.8644L113.732 23.4995H118.767L116.25 16.8644ZM121.844 12.3921C122.042 12.0286 122.498 11.8949 122.861 12.0935C124.947 13.233 126.513 14.6962 127.543 16.4806C128.573 18.265 129.058 20.3526 129.002 22.7286C128.992 23.1427 128.648 23.4705 128.234 23.4608C127.82 23.451 127.492 23.1074 127.502 22.6933C127.552 20.582 127.131 18.7659 126.244 17.2306C125.358 15.6952 123.996 14.4224 122.142 13.4098C121.779 13.2112 121.645 12.7556 121.844 12.3921ZM121.606 15.9936C121.805 15.6299 122.26 15.4958 122.624 15.6941C123.591 16.2214 124.366 16.9888 124.94 17.9834C125.514 18.9781 125.792 20.033 125.765 21.134C125.755 21.5481 125.411 21.8756 124.997 21.8655C124.582 21.8554 124.255 21.5115 124.265 21.0975C124.285 20.2759 124.079 19.4925 123.641 18.7334C123.203 17.9744 122.627 17.4045 121.906 17.0111C121.542 16.8128 121.408 16.3572 121.606 15.9936Z" />
            <path
              d="M173.212 27.11L178.043 13.4991C178.266 12.8727 179.113 12.8359 179.408 13.3887L179.457 13.4992L184.957 28.9997C185.096 29.3901 184.891 29.8188 184.501 29.9573C184.143 30.0843 183.753 29.9233 183.584 29.5949L183.543 29.5013L181.946 25H175.552L173.973 29.4521C173.92 29.6396 173.795 29.8048 173.617 29.9045L173.525 29.9482C173.172 30.0875 172.777 29.9401 172.596 29.6178L172.552 29.5256L171.556 27H167.443L166.448 29.5209C166.308 29.874 165.93 30.0621 165.572 29.9737L165.474 29.9426C165.121 29.803 164.933 29.4253 165.022 29.0666L165.053 28.9694L168.806 19.4743C169.042 18.8788 169.849 18.8441 170.151 19.3698L170.202 19.4749L173.212 27.11L178.043 13.4991L173.212 27.11ZM169.503 21.7923L168.036 25.5H170.964L169.503 21.7923ZM178.75 15.9925L176.084 23.5H181.414L178.75 15.9925Z" />
            <path
              d="M67.9613 15.9863C68.0918 15.5932 67.8789 15.1687 67.4858 15.0382C67.0927 14.9077 66.6682 15.1206 66.5377 15.5137C66.3898 15.9592 66.2337 16.5537 66.1181 17.0262C65.3819 17.0514 64.6725 17.0442 64.0512 17.0017C63.638 16.9735 63.28 17.2856 63.2518 17.6988C63.2235 18.1121 63.5356 18.47 63.9489 18.4982C64.512 18.5367 65.1391 18.5486 65.7931 18.5355C65.6493 19.3012 65.5518 19.9846 65.4928 20.5993C64.2779 21.2417 63.4318 22.1039 62.9543 23.0117C62.3412 24.1774 62.2937 25.5681 63.1596 26.4545C63.7313 27.0389 64.5679 27.0948 65.2889 26.9401C65.6945 26.853 66.1145 26.6917 66.5292 26.4658C66.5352 26.4815 66.5411 26.497 66.5468 26.5123C66.6917 26.9003 67.1237 27.0975 67.5118 26.9527C67.8998 26.8078 68.097 26.3758 67.9522 25.9878C67.8956 25.8361 67.8385 25.6964 67.7818 25.5639C68.8051 24.6281 69.6965 23.2555 70.0671 21.5172C70.7047 21.8293 71.1363 22.3527 71.345 22.9164C71.5723 23.5301 71.5579 24.2288 71.2479 24.8692C70.9403 25.5045 70.3154 26.1336 69.2327 26.55C68.8461 26.6986 68.6532 27.1326 68.8018 27.5192C68.9505 27.9058 69.3844 28.0987 69.771 27.95C71.1576 27.4169 72.1017 26.5478 72.598 25.5228C73.0918 24.5029 73.116 23.3793 72.7517 22.3955C72.3384 21.2796 71.4512 20.3851 70.2474 19.9718C70.2492 19.8984 70.2501 19.8244 70.2501 19.75C70.2501 19.3358 69.9143 19 69.5001 19C69.0948 19 68.7646 19.3215 68.7506 19.7234C68.2257 19.7192 67.6655 19.7942 67.0784 19.9612C67.1416 19.5056 67.2261 19.0075 67.3354 18.4612C68.5197 18.3718 69.6989 18.2086 70.6716 17.9801C71.0748 17.8854 71.3249 17.4817 71.2302 17.0785C71.1354 16.6752 70.7317 16.4251 70.3285 16.5199C69.5605 16.7003 68.6387 16.8377 67.6905 16.926C67.7765 16.5962 67.8719 16.2555 67.9613 15.9863ZM64.2819 23.71C64.5082 23.2797 64.8817 22.8236 65.4278 22.4103C65.4449 22.9013 65.4933 23.3355 65.5646 23.7274C65.6589 24.246 65.8005 24.7011 65.9508 25.0996C65.6455 25.2709 65.3192 25.3994 64.9741 25.4735C64.4893 25.5775 64.2868 25.4618 64.2317 25.4055C63.9929 25.161 63.8383 24.5533 64.2819 23.71ZM68.5959 21.2225C68.3869 22.1892 67.8955 23.2446 67.1823 24.0706C67.1295 23.887 67.0817 23.6861 67.0404 23.459C66.9513 22.9693 66.9006 22.3671 66.9286 21.5929C67.0381 21.5508 67.1511 21.5105 67.2676 21.472C67.7491 21.313 68.1924 21.2351 68.5959 21.2225ZM58.9608 16.5299C56.7212 15.8782 54.9577 16.681 54.3851 16.997C54.0225 17.1971 53.8907 17.6533 54.0908 18.016C54.2909 18.3786 54.7472 18.5104 55.1098 18.3103C55.5147 18.0869 56.8461 17.4771 58.541 17.9699C59.314 18.1969 59.639 18.6091 59.8054 19.0259C59.9378 19.3579 59.9795 19.7168 59.9926 20.0681C59.7234 19.9929 59.412 19.9181 59.0705 19.8574C57.9379 19.6561 56.3879 19.5948 54.9479 20.2845C53.3617 21.0443 52.8175 22.6008 53.0459 23.9815C53.2704 25.3382 54.2623 26.6481 55.8461 26.9331C57.2756 27.1904 58.6515 26.6772 59.6034 26.1717C59.7421 26.0981 59.8741 26.0234 59.9985 25.9494V26.25C59.9985 26.6642 60.3343 27 60.7485 27C61.1627 27 61.4985 26.6642 61.4985 26.25L61.4985 20.4603C61.4988 20.0062 61.4993 19.2237 61.1986 18.47C60.8677 17.6409 60.1943 16.8917 58.9625 16.5303L58.9608 16.5299ZM58.808 21.3343C59.2914 21.4202 59.7056 21.5401 59.9985 21.6386V24.1446C59.9662 24.1691 59.9311 24.1953 59.8934 24.2229C59.6526 24.3991 59.3091 24.6297 58.9 24.8469C58.0591 25.2934 57.0502 25.6257 56.1118 25.4568C55.2674 25.3049 54.6671 24.591 54.5258 23.7367C54.3884 22.9063 54.7048 22.0642 55.5959 21.6373C56.6334 21.1404 57.8217 21.159 58.808 21.3343Z" />
            <path
              d="M239.026 27.0013C236.264 31.7849 230.147 33.424 225.363 30.6621C224.061 29.91 222.964 28.8925 222.129 27.6796C221.849 27.274 222.03 26.714 222.494 26.548C226.261 25.1996 228.279 23.637 229.45 21.4019C230.682 19.049 231.001 16.4715 230.139 12.9385C230.019 12.45 230.405 11.9848 230.908 12.0117C232.464 12.0953 233.986 12.5425 235.365 13.3389C240.149 16.1008 241.788 22.2176 239.026 27.0013ZM230.779 22.098C229.527 24.4866 227.467 26.1971 223.961 27.5969C224.569 28.2927 225.293 28.8893 226.113 29.3631C230.18 31.7107 235.379 30.3175 237.727 26.2513C240.074 22.185 238.681 16.9856 234.615 14.6379C233.738 14.1316 232.795 13.7916 231.823 13.6224C232.47 17.0064 232.053 19.6661 230.779 22.098Z" />
            <path class="button-select"
              d="M231 27.0049C231 24.2435 233.239 22.0049 236 22.0049C238.761 22.0049 241 24.2435 241 27.0049C241 29.7663 238.761 32.0049 236 32.0049C233.239 32.0049 231 29.7663 231 27.0049ZM238.354 26.1084C238.549 25.9132 238.549 25.5966 238.354 25.4013C238.158 25.2061 237.842 25.2061 237.646 25.4013L235.5 27.5478L234.354 26.4013C234.158 26.2061 233.842 26.2061 233.646 26.4013C233.451 26.5966 233.451 26.9132 233.646 27.1084L235.146 28.6084C235.342 28.8037 235.658 28.8037 235.854 28.6084L238.354 26.1084Z" />
          </g>
        </svg>
        `}lightMaskSVG(){return o`
    <svg class="phone-light-mask" width="510" height="827" viewBox="0 0 510 827" fill="none"
      xmlns="http://www.w3.org/2000/svg">
      <g clip-path="url(#clip0_2065_87267)">
        <g opacity="0.5" filter="url(#filter0_f_2065_87267)">
          <path d="M189 826.025L296 459.025V826.025H189Z" fill="black" />
        </g>
        <g opacity="0.2" filter="url(#filter1_f_2065_87267)">
          <path d="M189 826.025L297 464.025V826.025H189Z" fill="black" />
        </g>
        <g opacity="0.2" filter="url(#filter2_f_2065_87267)">
          <path d="M2 826.025L36 689.025V826.025H2Z" fill="black" />
        </g>
        <g opacity="0.2" filter="url(#filter3_f_2065_87267)">
          <path d="M3 826.025L11 756.025V826.025H3Z" fill="black" />
        </g>
        <g opacity="0.4">
          <g opacity="0.89" filter="url(#filter4_f_2065_87267)">
            <path d="M415.108 52.3746L439.604 51.3857L277.254 493.374L118.627 401.791L415.108 52.3746Z"
              fill="url(#paint0_linear_2065_87267)" />
          </g>
        </g>
        <g clip-path="url(#clip1_2065_87267)">
          <g opacity="0.8" filter="url(#filter5_f_2065_87267)">
            <path d="M149 382.025L-3 547.025V427.025C-3 402.172 17.1472 382.025 42 382.025H149Z" fill="black" />
          </g>
        </g>
      </g>
      <defs>
        <filter id="filter0_f_2065_87267" x="160" y="430.025" width="165" height="425" filterUnits="userSpaceOnUse"
          color-interpolation-filters="sRGB">
          <feFlood flood-opacity="0" result="BackgroundImageFix" />
          <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
          <feGaussianBlur stdDeviation="14.5" result="effect1_foregroundBlur_2065_87267" />
        </filter>
        <filter id="filter1_f_2065_87267" x="160" y="435.025" width="166" height="420" filterUnits="userSpaceOnUse"
          color-interpolation-filters="sRGB">
          <feFlood flood-opacity="0" result="BackgroundImageFix" />
          <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
          <feGaussianBlur stdDeviation="14.5" result="effect1_foregroundBlur_2065_87267" />
        </filter>
        <filter id="filter2_f_2065_87267" x="-27" y="660.025" width="92" height="195" filterUnits="userSpaceOnUse"
          color-interpolation-filters="sRGB">
          <feFlood flood-opacity="0" result="BackgroundImageFix" />
          <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
          <feGaussianBlur stdDeviation="14.5" result="effect1_foregroundBlur_2065_87267" />
        </filter>
        <filter id="filter3_f_2065_87267" x="-12" y="741.025" width="38" height="100" filterUnits="userSpaceOnUse"
          color-interpolation-filters="sRGB">
          <feFlood flood-opacity="0" result="BackgroundImageFix" />
          <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
          <feGaussianBlur stdDeviation="7.5" result="effect1_foregroundBlur_2065_87267" />
        </filter>
        <filter id="filter4_f_2065_87267" x="92.627" y="25.3857" width="372.977" height="493.988"
          filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
          <feFlood flood-opacity="0" result="BackgroundImageFix" />
          <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
          <feGaussianBlur stdDeviation="13" result="effect1_foregroundBlur_2065_87267" />
        </filter>
        <filter id="filter5_f_2065_87267" x="-32" y="353.025" width="210" height="223" filterUnits="userSpaceOnUse"
          color-interpolation-filters="sRGB">
          <feFlood flood-opacity="0" result="BackgroundImageFix" />
          <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
          <feGaussianBlur stdDeviation="14.5" result="effect1_foregroundBlur_2065_87267" />
        </filter>
        <linearGradient id="paint0_linear_2065_87267" x1="423.871" y1="56.2616" x2="197.941" y2="447.584"
          gradientUnits="userSpaceOnUse">
          <stop stop-color="white" />
          <stop offset="1" stop-color="white" stop-opacity="0" />
        </linearGradient>
        <clipPath id="clip0_2065_87267">
          <rect width="509.228" height="826.025" fill="white" />
        </clipPath>
        <clipPath id="clip1_2065_87267">
          <path d="M0 412.025C0 395.456 13.4315 382.025 30 382.025H208V567.025H0V412.025Z" fill="white" />
        </clipPath>
      </defs>
    </svg>
    `}});