// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{html as e,css as o,LitElement as r,unsafeCSS as t}from"../../lit.js";import{MixinKeyEvent as s,MixinAttributes as d}from"../../controls/control-base.js";import{getOsType as i}from"../../environment.js";customElements.define("dewey-toggle",d(s(class extends r{constructor(){super(...arguments),this.handleChange=e=>{const o=e.target;this.checked=o.checked,this.onChange&&this.onChange(this.checked)}}static get properties(){return{checked:{type:Boolean,reflect:!0},disabled:{type:Boolean,reflect:!0}}}static get styles(){const e="iOS"===i(),r=e?"31px":"32px",s=e?"28px":"26px",d=e?"1.5px":"3px",a=e?"21.5px":"23px",n=e?"--color-neutral-background-disabled-transparency":"--color-neutral-foreground-disabled-solid",l=e?"--color-neutral-background-disabled-transparency":"--color-neutral-foreground-disabled-solid";return o`
            :host {
                position: relative;
                display: inline-block;
                width: ${t(e?"51px":"52px")};
                height: ${t(r)};
                -webkit-tap-highlight-color: transparent;
            }

            .switch input {
                opacity: 0;
                width: 0;
                height: 0;
            }

            /* The slider. */
            .slider {
                position: absolute;
                cursor: pointer;
                top: 0;
                left: 0;
                right: 0;
                bottom: 0;
                background-color: var(--color-brand-background1);
                transition: background-color 500ms;
                -webkit-transition: background-color 500ms;
            }

            .slider:before{
                position: absolute;
                content: "";
                height: ${t(s)};
                width: ${t(s)};
                top: ${t(d)};
                left: ${t(a)};
                background-color: var(--color-neutral-foreground-static-inverted-solid);
                transition: transform 300ms, background-color 200ms;
                -webkit-transition: transform 300ms, background-color 200ms;
                border-radius: 50%;
            }

            :host([checked]) .slider {
                background-color: var(${t(n)});
            }
            :host([checked]) .slider:before {
                transform: translateX(-20px);
            }

            :host([disabled]) .slider {
                cursor: not-allowed;
                background-color: var(--color-brand-background-disabled);
            }

            :host([disabled]) .slider:before {
                opacity: 0.4;
            }
            
            :host([disabled][checked]) .slider {
                background-color: var(${t(l)});
            }
            


            /* Rounded sliders */
            .slider.round {
                border-radius: 20px;
            }

            .slider.round:before {
                border-radius: 50%;
            }

            /* Android specific thumb shadows */
            ${e?o``:o`
                    .slider:before {
                    box-shadow: 0px 0px 2px 0px rgba(0, 0, 0, 0.12),
                                0px 4px 8px 0px rgba(0, 0, 0, 0.14);
                    }
                `}
        `}render(){return e`
            <label class='switch'>
                <input 
                    type="checkbox"
                    ?checked = ${this.checked}
                    ?disabled = ${this.disabled}
                    @change=${this.handleChange}
                />
                <span class="slider round"> </span>
            </label>
        `}}),{role:"toggle"}));