// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{html as e,css as r,LitElement as t}from"../../lit.js";import{MixinKeyEvent as o,MixinAttributes as i}from"../../controls/control-base.js";import{getOsType as s}from"../../environment.js";class l extends t{constructor(){super(...arguments),this.onClick=e=>{e.stopPropagation(),this.disabled||(this.checked=!this.checked,this.onChange&&this.onChange(this.checked))}}static get properties(){return{checked:{type:Boolean,reflect:!0},disabled:{type:Boolean,reflect:!0},type:{type:String,reflect:!0}}}static get styles(){return[this.baseStyles,this.checkmarkStyles,this.circleStyles]}getType(){return"checkmark"===this.type||"circle"===this.type?this.type:"iOS"===s()?"checkmark":"circle"}connectedCallback(){super.connectedCallback(),this.addEventListener("click",this.onClick)}disconnectedCallback(){super.disconnectedCallback(),this.removeEventListener("click",this.onClick)}renderCircle(){return e`
            <div class="outer"></div>
            <div class="inner"></div>
        `}renderCheckmark(){return e`
        <svg width="18" height="13" viewBox="0 0 18 13" 
        fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M1.53033 6.96967C1.23744 6.67678 0.762563 6.67678 0.46967 
        6.96967C0.176777 7.26256 0.176777 7.73744 0.46967 8.03033L4.96967 
        12.5303C5.26256 12.8232 5.73744 12.8232 6.03033 12.5303L17.0303 
        1.53033C17.3232 1.23744 17.3232 0.762563 17.0303 0.46967C16.7374 
        0.176777 16.2626 0.176777 15.9697 0.46967L5.5 10.9393L1.53033 6.96967Z" 
        />
        </svg>
        `}render(){return"checkmark"===this.getType()?this.renderCheckmark():this.renderCircle()}}l.baseStyles=r`
      :host {
        position: relative;
        display: inline-block;
        width: 24px;
        height: 24px;
        -webkit-tap-highlight-color: transparent;
      }
    `,l.checkmarkStyles=r`
      /* Checkmark Styles (Original iOS styles) */
      svg {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        margin: auto;
        transition: all 100ms;
        opacity: 1;
        fill: var(--color-brand-foreground1);
      }

      :host([disabled]) svg {
        opacity: 0;
      }

      :host([checked]) svg {
        fill: var(--color-brand-foreground-disabled);
      }
    `,l.circleStyles=r`
      /* Circle Styles. (Original Android styles) */
      .outer {
        --size: 20px;
        position: absolute;
        width: var(--size);
        height: var(--size);
        border-radius: 100px;
        border-width: 1.5px;
        border-style: solid;
        border-color: var(--color-neutral-stroke-accessible-transparency);
        box-sizing: border-box;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        margin: auto;
        transition: all 100ms;
      }

      :host([checked]) .outer {
        border-color: var(--color-brand-foreground1);
      }

      :host([disabled]) .outer {
        border-color: var(--color-neutral-stroke-disabled-solid);
      }

      :host([disabled][checked]) .outer {
        border-color: var(--color-brand-foreground-disabled);
      }

      .inner {
        --size: 10px;
        position: absolute;
        width: var(--size);
        height: var(--size);
        border-radius: 50%;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        margin: auto;
        transition: all 100ms;
        opacity: 0;
        background-color: var(--color-brand-foreground1);
      }

      :host([checked]) .inner {
        opacity: 1;
      }

      :host([disabled][checked]) .inner {
        background-color: var(--color-brand-foreground-disabled);
      }
    `,customElements.define("dewey-radio-button",i(o(l),{role:"radio-button"}));