// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{html as t,css as e,LitElement as C}from"../../lit.js";import{MixinKeyEvent as i,MixinAttributes as a}from"../../controls/control-base.js";import{getOsType as r}from"../../environment.js";export var AvatarSize;!function(t){t.SIZE_24="24",t.SIZE_32="32",t.SIZE_40="40",t.SIZE_56="56",t.SIZE_64="64",t.SIZE_72="72"}(AvatarSize||(AvatarSize={}));export var AvatarBadgeState;!function(t){t.SYNC_ON="sync-on",t.SYNC_OFF="sync-off",t.SYNCING="syncing",t.CONNECTED="connected",t.DISCONNECTED="disconnected"}(AvatarBadgeState||(AvatarBadgeState={}));export var AvatarImage;!function(t){t.NON_SIGN_IN="non-sign-in",t.MSA="msa",t.AAD="aad"}(AvatarImage||(AvatarImage={}));customElements.define("dewey-avatar",a(i(class extends C{constructor(){super(),this.onColorSchemeChange_=()=>{this.requestUpdate()},this.internals_=this.attachInternals(),this.internals_.role="img"}connectedCallback(){super.connectedCallback(),this.colorSchemeMediaQuery_=window.matchMedia("(prefers-color-scheme: dark)"),this.colorSchemeMediaQuery_.addEventListener("change",this.onColorSchemeChange_)}disconnectedCallback(){super.disconnectedCallback(),this.colorSchemeMediaQuery_.removeEventListener("change",this.onColorSchemeChange_)}get isDarkMode(){return window.matchMedia("(prefers-color-scheme: dark)").matches}getBackgroundColor(){const t="iOS"===r();return this.image===AvatarImage.NON_SIGN_IN?t?this.isDarkMode?"var(--color-neutral-background-disabled-transparency)":"var(--color-neutral-foreground-hint-transparency)":this.isDarkMode?"var(--color-neutral-foreground-disabled-on-brand-solid)":"var(--color-neutral-foreground-hint-solid)":this.image===AvatarImage.MSA||this.image===AvatarImage.AAD?"var(--color-brand-foreground1)":"transparent"}static get properties(){return{size:{type:AvatarSize},badge:{type:AvatarBadgeState},image:{type:String,reflect:!0}}}static get styles(){return e`
      :host {
        position: relative;
        display: inline-block;
        -webkit-tap-highlight-color: transparent;
      }

      .container {
        position; absolute;
        width: var(--avatar-size);
        height: var(--avatar-size);
        border-radius: 50%;
        background-color: var(--avatar-color);
        justify-content: center;
        align-items: center;
        display: flex;
      }

      .badge {
        display: flex;
        flex-direction: row;
        justify-content: center;
        align-items: center;
        padding: 0px;
        gap: 10px;

        position: absolute;
        width: var(--badge-size);
        height: var(--badge-size);
        bottom: 0px;
        right: 0px;
      }

      .type-icon {
        display: flex;
        align-items: center;
        justify-content: center;
        background-color: transparent;
        position: absolute;
        transform: translate(-50%, -50%);
        left: 50%;
        top: 50%;
      }
      :host([badge = "connected"]) .badge,
      :host([badge = "disconnected"]) .badge  {
        background-color: transparent;
        border: 0px;
      }

      .avatar-image {
        width: 100%;
        height: 100%;
        object-fit: cover;
        border-radius: 50%;
      }
    `}renderBadgeIcon(e){const C=this.isDarkMode;switch(e){case AvatarBadgeState.SYNC_ON:return C?t`
            <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
            <rect x="0.5" y="0.5" width="17" height="17" rx="8.5" fill="#141414"/>
            <rect x="0.5" y="0.5" width="17" height="17" rx="8.5" stroke="#141414"/>
            <g clip-path="url(#clip0_12080_15037)">
            <path d="M1 9C1 4.58172 4.58172 1 9 1C13.4183 1 17 4.58172 17 9C17 13.4183 13.4183 17 9 17C4.58172 17 1 13.4183 1 9Z" fill="white"/>
            <path d="M9 1C13.4183 1 17 4.58172 17 9C17 13.4183 13.4183 17 9 17C4.58172 17 1 13.4183 1 9C1 4.58172 4.58172 1 9 1ZM11.827 6.55197L7.99937 10.3899L6.13807 8.5286C5.87772 8.26825 5.45561 8.26825 5.19526 8.5286C4.93491 8.78895 4.93491 9.21106 5.19526 9.47141L7.5286 11.8047C7.78919 12.0653 8.21179 12.0651 8.47203 11.8041L12.7711 7.49352C13.0311 7.23282 13.0305 6.81072 12.7698 6.55071C12.5091 6.29071 12.087 6.29128 11.827 6.55197Z" fill="#54B054"/>
            </g>
            <defs>
            <clipPath id="clip0_12080_15037">
            <path d="M1 9C1 4.58172 4.58172 1 9 1C13.4183 1 17 4.58172 17 9C17 13.4183 13.4183 17 9 17C4.58172 17 1 13.4183 1 9Z" fill="white"/>
            </clipPath>
            </defs>
            </svg>
              `:t`
            <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
            <rect x="0.5" y="0.5" width="17" height="17" rx="8.5" fill="white"/>
            <rect x="0.5" y="0.5" width="17" height="17" rx="8.5" stroke="white"/>
            <g clip-path="url(#clip0_10658_3727)">
            <path d="M9 1C13.4183 1 17 4.58172 17 9C17 13.4183 13.4183 17 9 17C4.58172 17 1 13.4183 1 9C1 4.58172 4.58172 1 9 1ZM11.827 6.55197L7.99937 10.3899L6.13807 8.5286C5.87772 8.26825 5.45561 8.26825 5.19526 8.5286C4.93491 8.78895 4.93491 9.21106 5.19526 9.47141L7.5286 11.8047C7.78919 12.0653 8.21179 12.0651 8.47203 11.8041L12.7711 7.49352C13.0311 7.23282 13.0305 6.81072 12.7698 6.55071C12.5091 6.29071 12.087 6.29128 11.827 6.55197Z" fill="#0E700E"/>
            </g>
            <defs>
            <clipPath id="clip0_10658_3727">
            <rect width="16" height="16" fill="white" transform="translate(1 1)"/>
            </clipPath>
            </defs>
            </svg>

              `;case AvatarBadgeState.SYNC_OFF:return C?t`
            <svg width="19" height="18" viewBox="0 0 19 18" fill="none" xmlns="http://www.w3.org/2000/svg">
            <rect x="1" y="0.5" width="17" height="17" rx="8.5" fill="#141414"/>
            <rect x="1" y="0.5" width="17" height="17" rx="8.5" stroke="#141414"/>
            <g clip-path="url(#clip0_12080_15042)">
            <path d="M1.5 9C1.5 4.58172 5.08172 1 9.5 1C13.9183 1 17.5 4.58172 17.5 9C17.5 13.4183 13.9183 17 9.5 17C5.08172 17 1.5 13.4183 1.5 9Z" fill="white"/>
            <path d="M9.5 1C5.08172 1 1.5 4.58172 1.5 9C1.5 13.4183 5.08172 17 9.5 17C13.9183 17 17.5 13.4183 17.5 9C17.5 4.58172 13.9183 1 9.5 1ZM6.16667 9H8.1656L8.28543 9.01074C8.59643 9.06719 8.83226 9.33939 8.83226 9.66667C8.83226 10.0349 8.53378 10.3333 8.1656 10.3333L7.72242 10.3341C8.13239 10.8795 8.78339 11.2219 9.5 11.2219C10.1125 11.2219 10.6838 10.9737 11.1004 10.5412C11.3559 10.2761 11.7779 10.2682 12.0431 10.5236C12.3083 10.779 12.3162 11.2011 12.0607 11.4662C11.3953 12.1571 10.4785 12.5552 9.5 12.5552C8.45189 12.5552 7.4917 12.0976 6.83346 11.3521L6.83333 11.6684L6.82259 11.7882C6.76615 12.0992 6.49395 12.3351 6.16667 12.3351C5.79848 12.3351 5.5 12.0366 5.5 11.6684V9.66667L5.51074 9.54683C5.56719 9.23583 5.83939 9 6.16667 9ZM9.5 5.44478C10.5505 5.44478 11.5103 5.90427 12.1675 6.649L12.1667 6.33737L12.1774 6.21754C12.2339 5.90654 12.5061 5.6707 12.8333 5.6707C13.2015 5.6707 13.5 5.96918 13.5 6.33737V8.33333L13.4893 8.45317C13.4328 8.76417 13.1606 9 12.8333 9H10.8388L10.719 8.98926C10.408 8.93281 10.1721 8.66061 10.1721 8.33333C10.1721 7.96514 10.4706 7.66667 10.8388 7.66667L11.2772 7.66541C10.8679 7.12151 10.2177 6.77811 9.5 6.77811C8.88494 6.77811 8.31142 7.02837 7.89444 7.46411C7.63988 7.73012 7.21787 7.7394 6.95185 7.48484C6.68584 7.23028 6.67656 6.80828 6.93112 6.54226C7.59709 5.84633 8.51734 5.44478 9.5 5.44478Z" fill="#54B054"/>
            </g>
            <defs>
            <clipPath id="clip0_12080_15042">
            <path d="M1.5 9C1.5 4.58172 5.08172 1 9.5 1C13.9183 1 17.5 4.58172 17.5 9C17.5 13.4183 13.9183 17 9.5 17C5.08172 17 1.5 13.4183 1.5 9Z" fill="white"/>
            </clipPath>
            </defs>
            </svg>
              `:t`
            <svg width="19" height="18" viewBox="0 0 19 18" fill="none" xmlns="http://www.w3.org/2000/svg">
            <rect x="1" y="0.5" width="17" height="17" rx="8.5" fill="white"/>
            <rect x="1" y="0.5" width="17" height="17" rx="8.5" stroke="white"/>
            <path d="M17.5 9C17.5 13.4183 13.9183 17 9.5 17C5.08172 17 1.5 13.4183 1.5 9H6.66955L5.54027 12.1055C5.41445 12.4515 5.59295 12.834 5.93897 12.9599C6.28499 13.0857 6.6675 12.9072 6.79333 12.5612L9.46001 5.22784C9.58583 4.88182 9.40733 4.49931 9.06131 4.37348C8.71529 4.24765 8.33278 4.42616 8.20695 4.77218L7.1544 7.66667H1.61061C2.24538 3.88305 5.53601 1 9.5 1C13.464 1 16.7546 3.88305 17.3894 7.66667H12.5732L13.46 5.22784C13.5858 4.88182 13.4073 4.49931 13.0613 4.37348C12.7153 4.24765 12.3328 4.42616 12.2069 4.77218L9.54028 12.1055C9.41446 12.4515 9.59296 12.834 9.93898 12.9599C10.285 13.0857 10.6675 12.9072 10.7933 12.5612L12.0883 9H17.5Z" fill="#BC2F32"/>
            </svg>
              `;case AvatarBadgeState.SYNCING:return C?t`
            <svg width="19" height="18" viewBox="0 0 19 18" fill="none" xmlns="http://www.w3.org/2000/svg">
            <rect x="1" y="0.5" width="17" height="17" rx="8.5" fill="#141414"/>
            <rect x="1" y="0.5" width="17" height="17" rx="8.5" stroke="#141414"/>
            <g clip-path="url(#clip0_12080_15042)">
            <path d="M1.5 9C1.5 4.58172 5.08172 1 9.5 1C13.9183 1 17.5 4.58172 17.5 9C17.5 13.4183 13.9183 17 9.5 17C5.08172 17 1.5 13.4183 1.5 9Z" fill="white"/>
            <path d="M9.5 1C5.08172 1 1.5 4.58172 1.5 9C1.5 13.4183 5.08172 17 9.5 17C13.9183 17 17.5 13.4183 17.5 9C17.5 4.58172 13.9183 1 9.5 1ZM6.16667 9H8.1656L8.28543 9.01074C8.59643 9.06719 8.83226 9.33939 8.83226 9.66667C8.83226 10.0349 8.53378 10.3333 8.1656 10.3333L7.72242 10.3341C8.13239 10.8795 8.78339 11.2219 9.5 11.2219C10.1125 11.2219 10.6838 10.9737 11.1004 10.5412C11.3559 10.2761 11.7779 10.2682 12.0431 10.5236C12.3083 10.779 12.3162 11.2011 12.0607 11.4662C11.3953 12.1571 10.4785 12.5552 9.5 12.5552C8.45189 12.5552 7.4917 12.0976 6.83346 11.3521L6.83333 11.6684L6.82259 11.7882C6.76615 12.0992 6.49395 12.3351 6.16667 12.3351C5.79848 12.3351 5.5 12.0366 5.5 11.6684V9.66667L5.51074 9.54683C5.56719 9.23583 5.83939 9 6.16667 9ZM9.5 5.44478C10.5505 5.44478 11.5103 5.90427 12.1675 6.649L12.1667 6.33737L12.1774 6.21754C12.2339 5.90654 12.5061 5.6707 12.8333 5.6707C13.2015 5.6707 13.5 5.96918 13.5 6.33737V8.33333L13.4893 8.45317C13.4328 8.76417 13.1606 9 12.8333 9H10.8388L10.719 8.98926C10.408 8.93281 10.1721 8.66061 10.1721 8.33333C10.1721 7.96514 10.4706 7.66667 10.8388 7.66667L11.2772 7.66541C10.8679 7.12151 10.2177 6.77811 9.5 6.77811C8.88494 6.77811 8.31142 7.02837 7.89444 7.46411C7.63988 7.73012 7.21787 7.7394 6.95185 7.48484C6.68584 7.23028 6.67656 6.80828 6.93112 6.54226C7.59709 5.84633 8.51734 5.44478 9.5 5.44478Z" fill="#54B054"/>
            </g>
            <defs>
            <clipPath id="clip0_12080_15042">
            <path d="M1.5 9C1.5 4.58172 5.08172 1 9.5 1C13.9183 1 17.5 4.58172 17.5 9C17.5 13.4183 13.9183 17 9.5 17C5.08172 17 1.5 13.4183 1.5 9Z" fill="white"/>
            </clipPath>
            </defs>
            </svg>
              `:t`
            <svg width="19" height="18" viewBox="0 0 19 18" fill="none" xmlns="http://www.w3.org/2000/svg">
            <rect x="1" y="0.5" width="17" height="17" rx="8.5" fill="white"/>
            <rect x="1" y="0.5" width="17" height="17" rx="8.5" stroke="white"/>
            <g clip-path="url(#clip0_10658_3739)">
            <path d="M9.5 1C5.08172 1 1.5 4.58172 1.5 9C1.5 13.4183 5.08172 17 9.5 17C13.9183 17 17.5 13.4183 17.5 9C17.5 4.58172 13.9183 1 9.5 1ZM6.16667 9H8.1656L8.28543 9.01074C8.59643 9.06719 8.83226 9.33939 8.83226 9.66667C8.83226 10.0349 8.53378 10.3333 8.1656 10.3333L7.72242 10.3341C8.13239 10.8795 8.78339 11.2219 9.5 11.2219C10.1125 11.2219 10.6838 10.9737 11.1004 10.5412C11.3559 10.2761 11.7779 10.2682 12.0431 10.5236C12.3083 10.779 12.3162 11.2011 12.0607 11.4662C11.3953 12.1571 10.4785 12.5552 9.5 12.5552C8.45189 12.5552 7.4917 12.0976 6.83346 11.3521L6.83333 11.6684L6.82259 11.7882C6.76615 12.0992 6.49395 12.3351 6.16667 12.3351C5.79848 12.3351 5.5 12.0366 5.5 11.6684V9.66667L5.51074 9.54683C5.56719 9.23583 5.83939 9 6.16667 9ZM9.5 5.44478C10.5505 5.44478 11.5103 5.90427 12.1675 6.649L12.1667 6.33737L12.1774 6.21754C12.2339 5.90654 12.5061 5.6707 12.8333 5.6707C13.2015 5.6707 13.5 5.96918 13.5 6.33737V8.33333L13.4893 8.45317C13.4328 8.76417 13.1606 9 12.8333 9H10.8388L10.719 8.98926C10.408 8.93281 10.1721 8.66061 10.1721 8.33333C10.1721 7.96514 10.4706 7.66667 10.8388 7.66667L11.2772 7.66541C10.8679 7.12151 10.2177 6.77811 9.5 6.77811C8.88494 6.77811 8.31142 7.02837 7.89444 7.46411C7.63988 7.73012 7.21787 7.7394 6.95185 7.48484C6.68584 7.23028 6.67656 6.80828 6.93112 6.54226C7.59709 5.84633 8.51734 5.44478 9.5 5.44478Z" fill="#0E700E"/>
            </g>
            <defs>
            <clipPath id="clip0_10658_3739">
            <rect width="16" height="16" fill="white" transform="translate(1.5 1)"/>
            </clipPath>
            </defs>
            </svg>
              `;case AvatarBadgeState.CONNECTED:return C?t`
            <svg width="19" height="18" viewBox="0 0 19 18" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M10.3267 0.842475C9.87129 0.386203 9.13213 0.385789 8.6762 0.841552C7.09815 2.419 5.38741 3.16667 3.49998 3.16667C2.85565 3.16667 2.33331 3.689 2.33331 4.33333V8.33501C2.33331 10.5683 2.90421 12.4808 4.06064 14.0258C5.21559 15.5687 6.92426 16.7045 9.13105 17.4401C9.37052 17.52 9.62943 17.52 9.86891 17.4401C12.0757 16.7045 13.7844 15.5687 14.9393 14.0258C16.0957 12.4808 16.6666 10.5683 16.6666 8.33501V4.33333C16.6666 3.689 16.1443 3.16667 15.5 3.16667C13.61 3.16667 11.9004 2.41907 10.3267 0.842475Z" fill="#4D8DFA" stroke="#141414"/>
            </svg>
              `:t`
            <svg width="19" height="18" viewBox="0 0 19 18" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M10.3267 0.842475C9.87129 0.386203 9.13213 0.385789 8.6762 0.841552C7.09815 2.419 5.38741 3.16667 3.49998 3.16667C2.85565 3.16667 2.33331 3.689 2.33331 4.33333V8.33501C2.33331 10.5683 2.90421 12.4808 4.06064 14.0258C5.21559 15.5687 6.92426 16.7045 9.13105 17.4401C9.37052 17.52 9.62943 17.52 9.86891 17.4401C12.0757 16.7045 13.7844 15.5687 14.9393 14.0258C16.0957 12.4808 16.6666 10.5683 16.6666 8.33501V4.33333C16.6666 3.689 16.1443 3.16667 15.5 3.16667C13.61 3.16667 11.9004 2.41907 10.3267 0.842475Z" fill="#2169EB" stroke="white"/>
            </svg>
              `;case AvatarBadgeState.DISCONNECTED:return C?t`
            <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M9.82672 0.842475C9.37129 0.386203 8.63213 0.385789 8.1762 0.841552C6.59815 2.419 4.88741 3.16667 2.99998 3.16667C2.35565 3.16667 1.83331 3.689 1.83331 4.33333V8.33501C1.83331 10.5683 2.40421 12.4808 3.56064 14.0258C4.71559 15.5687 6.42426 16.7045 8.63105 17.4401C8.87052 17.52 9.12943 17.52 9.36891 17.4401C11.5757 16.7045 13.2844 15.5687 14.4393 14.0258C15.5957 12.4808 16.1666 10.5683 16.1666 8.33501V4.33333C16.1666 3.689 15.6443 3.16667 15 3.16667C13.11 3.16667 11.4004 2.41907 9.82672 0.842475Z" fill="#999999" stroke="#141414"/>
            </svg>
              `:t`
            <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M9.82672 0.842475C9.37129 0.386203 8.63213 0.385789 8.1762 0.841552C6.59815 2.419 4.88741 3.16667 2.99998 3.16667C2.35565 3.16667 1.83331 3.689 1.83331 4.33333V8.33501C1.83331 10.5683 2.40421 12.4808 3.56064 14.0258C4.71559 15.5687 6.42426 16.7045 8.63105 17.4401C8.87052 17.52 9.12943 17.52 9.36891 17.4401C11.5757 16.7045 13.2844 15.5687 14.4393 14.0258C15.5957 12.4808 16.1666 10.5683 16.1666 8.33501V4.33333C16.1666 3.689 15.6443 3.16667 15 3.16667C13.11 3.16667 11.4004 2.41907 9.82672 0.842475Z" fill="#707070" stroke="white"/>
            </svg>
              `}}renderImageIcon(e,C){const i="iOS"===r(),a=this.isDarkMode;let s;if(s=i?a?e===AvatarImage.NON_SIGN_IN?"var(--color-neutral-foreground2-transparency)":"var(--color-neutral-foreground-static-inverted-transparency)":"(--color-neutral-foreground-on-brand)":a&&e===AvatarImage.NON_SIGN_IN?"var(--color-neutral-foreground2-solid)":"var(--color-neutral-foreground-static-inverted-solid)",e===AvatarImage.NON_SIGN_IN)switch(C){case AvatarSize.SIZE_24:return t`
            <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M9.62596 5.06907C8.31349 5.27865 7.15594 5.95255 6.32704 6.91706C5.13357 6.61687 4.25 5.53662 4.25 4.25C4.25 2.73122 5.48122 1.5 7 1.5C8.51878 1.5 9.75 2.73122 9.75 4.25C9.75 4.53525 9.70657 4.81036 9.62596 5.06907ZM5.59971 8C5.21628 8.75007 5 9.59978 5 10.5C5 11.8095 5.45766 13.0122 6.22176 13.9567C3.55468 13.653 2 11.8026 2 10V9.5C2 8.67157 2.67157 8 3.5 8H5.59971ZM10.5 15C12.9853 15 15 12.9853 15 10.5C15 8.01472 12.9853 6 10.5 6C8.01472 6 6 8.01472 6 10.5C6 12.9853 8.01472 15 10.5 15ZM10.5 8C10.7761 8 11 8.22386 11 8.5V10H12.5C12.7761 10 13 10.2239 13 10.5C13 10.7761 12.7761 11 12.5 11H11V12.5C11 12.7761 10.7761 13 10.5 13C10.2239 13 10 12.7761 10 12.5V11H8.5C8.22386 11 8 10.7761 8 10.5C8 10.2239 8.22386 10 8.5 10H10V8.5C10 8.22386 10.2239 8 10.5 8Z" fill="${s}"/>
            </svg>
          `;case AvatarSize.SIZE_32:return t`
          <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
          <path d="M9 2C6.79086 2 5 3.79086 5 6C5 8.20914 6.79086 10 9 10C11.2091 10 13 8.20914 13 6C13 3.79086 11.2091 2 9 2ZM4.00873 11C2.90315 11 2 11.8869 2 13C2 14.6912 2.83281 15.9663 4.13499 16.7966C5.41697 17.614 7.14526 18 9 18C9.41085 18 9.8155 17.9811 10.2105 17.9427C9.45316 17.0003 9 15.8031 9 14.5C9 13.1704 9.47182 11.9509 10.2572 11L4.00873 11ZM14.5 19C16.9853 19 19 16.9853 19 14.5C19 12.0147 16.9853 10 14.5 10C12.0147 10 10 12.0147 10 14.5C10 16.9853 12.0147 19 14.5 19ZM14.5 12C14.7761 12 15 12.2239 15 12.5V14H16.5C16.7761 14 17 14.2239 17 14.5C17 14.7761 16.7761 15 16.5 15H15V16.5C15 16.7761 14.7761 17 14.5 17C14.2239 17 14 16.7761 14 16.5V15H12.5C12.2239 15 12 14.7761 12 14.5C12 14.2239 12.2239 14 12.5 14H14V12.5C14 12.2239 14.2239 12 14.5 12Z" fill="${s}"/>
          </svg>
          `;case AvatarSize.SIZE_40:return t`
            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M11.0004 17.5003C11.0004 16.2113 11.3755 15.01 12.0226 13.9996L4.25278 14.0002C3.01076 14.0002 2.00391 15.007 2.00391 16.2491V17.169C2.00391 17.7411 2.18231 18.2989 2.51427 18.7648C4.05643 20.9292 6.5794 22.0013 10.0004 22.0013C10.9317 22.0013 11.7966 21.9219 12.5921 21.7618C11.6006 20.6207 11.0004 19.1306 11.0004 17.5003ZM15.0004 7.00488C15.0004 4.24346 12.7618 2.00488 10.0004 2.00488C7.23894 2.00488 5.00036 4.24346 5.00036 7.00488C5.00036 9.76631 7.23894 12.0049 10.0004 12.0049C12.7618 12.0049 15.0004 9.76631 15.0004 7.00488ZM23.0004 17.5002C23.0004 14.4627 20.5379 12.0002 17.5004 12.0002C14.4628 12.0002 12.0004 14.4627 12.0004 17.5002C12.0004 20.5378 14.4628 23.0002 17.5004 23.0002C20.5379 23.0002 23.0004 20.5378 23.0004 17.5002ZM17.4105 14.0083L17.5004 14.0002L17.5902 14.0083C17.7943 14.0453 17.9553 14.2063 17.9923 14.4104L18.0004 14.5002L17.9994 17.0002H20.5043L20.5942 17.0083C20.7982 17.0453 20.9592 17.2063 20.9962 17.4104L21.0043 17.5002L20.9962 17.5901C20.9592 17.7942 20.7982 17.9551 20.5942 17.9922L20.5043 18.0002H17.9994L18.0004 20.5002L17.9923 20.5901C17.9553 20.7942 17.7943 20.9551 17.5902 20.9922L17.5004 21.0002L17.4105 20.9922C17.2064 20.9551 17.0455 20.7942 17.0084 20.5901L17.0004 20.5002L16.9994 18.0002H14.5043L14.4144 17.9922C14.2103 17.9551 14.0494 17.7942 14.0123 17.5901L14.0043 17.5002L14.0123 17.4104C14.0494 17.2063 14.2103 17.0453 14.4144 17.0083L14.5043 17.0002H16.9994L17.0004 14.5002L17.0084 14.4104C17.0455 14.2063 17.2064 14.0453 17.4105 14.0083Z" fill="${s}"/>
            </svg>
          `;case AvatarSize.SIZE_56:return t`
            <svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M16 16C19.866 16 23 12.866 23 8.99998C23 5.134 19.866 2 16 2C12.134 2 9 5.134 9 8.99998C9 12.866 12.134 16 16 16ZM7.5 18C5.56696 18 3.99994 19.567 4 21.5001L4.00001 22C4.00003 24.3935 5.52264 26.4174 7.68492 27.7934C9.85906 29.177 12.8015 30 15.9999 30C16.4154 30 16.8266 29.9861 17.2324 29.9589C15.5472 28.3233 14.5 26.0339 14.5 23.5C14.5 21.4287 15.1997 19.5209 16.3756 18H7.5ZM23.5 31C27.6421 31 31 27.6421 31 23.5C31 19.3579 27.6421 16 23.5 16C19.3579 16 16 19.3579 16 23.5C16 27.6421 19.3579 31 23.5 31ZM24.5 18.75V22.5H28.25C28.6642 22.5 29 22.8358 29 23.25C29 23.6642 28.6642 24 28.25 24H24.5V27.75C24.5 28.1642 24.1642 28.5 23.75 28.5C23.3358 28.5 23 28.1642 23 27.75V24H19.25C18.8358 24 18.5 23.6642 18.5 23.25C18.5 22.8358 18.8358 22.5 19.25 22.5H23V18.75C23 18.3358 23.3358 18 23.75 18C24.1642 18 24.5 18.3358 24.5 18.75Z" fill="${s}"/>
            </svg>
          `;case AvatarSize.SIZE_64:return t`
            <svg width="38" height="38" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M16 16C19.866 16 23 12.866 23 8.99998C23 5.134 19.866 2 16 2C12.134 2 9 5.134 9 8.99998C9 12.866 12.134 16 16 16ZM7.5 18C5.56696 18 3.99994 19.567 4 21.5001L4.00001 22C4.00003 24.3935 5.52264 26.4174 7.68492 27.7934C9.85906 29.177 12.8015 30 15.9999 30C16.4154 30 16.8266 29.9861 17.2324 29.9589C15.5472 28.3233 14.5 26.0339 14.5 23.5C14.5 21.4287 15.1997 19.5209 16.3756 18H7.5ZM23.5 31C27.6421 31 31 27.6421 31 23.5C31 19.3579 27.6421 16 23.5 16C19.3579 16 16 19.3579 16 23.5C16 27.6421 19.3579 31 23.5 31ZM24.5 18.75V22.5H28.25C28.6642 22.5 29 22.8358 29 23.25C29 23.6642 28.6642 24 28.25 24H24.5V27.75C24.5 28.1642 24.1642 28.5 23.75 28.5C23.3358 28.5 23 28.1642 23 27.75V24H19.25C18.8358 24 18.5 23.6642 18.5 23.25C18.5 22.8358 18.8358 22.5 19.25 22.5H23V18.75C23 18.3358 23.3358 18 23.75 18C24.1642 18 24.5 18.3358 24.5 18.75Z" fill="${s}"/>
            </svg>
          `;case AvatarSize.SIZE_72:return t`
            <svg width="48" height="48" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M16 16C19.866 16 23 12.866 23 8.99998C23 5.134 19.866 2 16 2C12.134 2 9 5.134 9 8.99998C9 12.866 12.134 16 16 16ZM7.5 18C5.56696 18 3.99994 19.567 4 21.5001L4.00001 22C4.00003 24.3935 5.52264 26.4174 7.68492 27.7934C9.85906 29.177 12.8015 30 15.9999 30C16.4154 30 16.8266 29.9861 17.2324 29.9589C15.5472 28.3233 14.5 26.0339 14.5 23.5C14.5 21.4287 15.1997 19.5209 16.3756 18H7.5ZM23.5 31C27.6421 31 31 27.6421 31 23.5C31 19.3579 27.6421 16 23.5 16C19.3579 16 16 19.3579 16 23.5C16 27.6421 19.3579 31 23.5 31ZM24.5 18.75V22.5H28.25C28.6642 22.5 29 22.8358 29 23.25C29 23.6642 28.6642 24 28.25 24H24.5V27.75C24.5 28.1642 24.1642 28.5 23.75 28.5C23.3358 28.5 23 28.1642 23 27.75V24H19.25C18.8358 24 18.5 23.6642 18.5 23.25C18.5 22.8358 18.8358 22.5 19.25 22.5H23V18.75C23 18.3358 23.3358 18 23.75 18C24.1642 18 24.5 18.3358 24.5 18.75Z" fill="${s}"/>
            </svg>
          `}else if(e===AvatarImage.MSA)switch(C){case AvatarSize.SIZE_24:return t`
            <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M11.5 8C12.3284 8 13 8.67157 13 9.5V10C13 11.9714 11.1405 14 8 14C4.85951 14 3 11.9714 3 10V9.5C3 8.67157 3.67157 8 4.5 8H11.5ZM8 1.5C9.51878 1.5 10.75 2.73122 10.75 4.25C10.75 5.76878 9.51878 7 8 7C6.48122 7 5.25 5.76878 5.25 4.25C5.25 2.73122 6.48122 1.5 8 1.5Z" fill="${s}"/>
            </svg>
          `;case AvatarSize.SIZE_32:return t`
            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M10 2C7.79086 2 6 3.79086 6 6C6 8.20914 7.79086 10 10 10C12.2091 10 14 8.20914 14 6C14 3.79086 12.2091 2 10 2ZM5.00873 11C3.90315 11 3 11.8869 3 13C3 14.6912 3.83281 15.9663 5.13499 16.7966C6.41697 17.614 8.14526 18 10 18C11.8547 18 13.583 17.614 14.865 16.7966C16.1672 15.9663 17 14.6912 17 13C17 11.8956 16.1045 11 15 11L5.00873 11Z" fill="${s}"/>
            </svg>
          `;case AvatarSize.SIZE_40:return t`
            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M17.7545 13.9997C18.9966 13.9997 20.0034 15.0065 20.0034 16.2486V17.167C20.0034 17.7404 19.8242 18.2994 19.4908 18.7659C17.9449 20.9292 15.4206 22.0008 12.0004 22.0008C8.5794 22.0008 6.05643 20.9287 4.51427 18.7643C4.18231 18.2984 4.00391 17.7406 4.00391 17.1685V16.2486C4.00391 15.0065 5.01076 13.9997 6.25278 13.9997H17.7545ZM12.0004 2.00439C14.7618 2.00439 17.0004 4.24297 17.0004 7.00439C17.0004 9.76582 14.7618 12.0044 12.0004 12.0044C9.23894 12.0044 7.00036 9.76582 7.00036 7.00439C7.00036 4.24297 9.23894 2.00439 12.0004 2.00439Z" fill="${s}"/>
            </svg>
            `;case AvatarSize.SIZE_56:return t`
            <svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M16 16C19.866 16 23 12.866 23 8.99998C23 5.134 19.866 2 16 2C12.134 2 9 5.134 9 8.99998C9 12.866 12.134 16 16 16ZM7.5 18C5.56696 18 3.99994 19.567 4 21.5001L4.00001 22C4.00003 24.3935 5.52264 26.4174 7.68492 27.7934C9.85906 29.177 12.8015 30 15.9999 30C19.1983 30 22.1408 29.177 24.315 27.7934C26.4773 26.4174 28 24.3935 28 22V21.5C28 19.567 26.433 18 24.5 18H7.5Z" fill="${s}"/>
            </svg>
            `;case AvatarSize.SIZE_64:return t`
            <svg width="38" height="38" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M16 16C19.866 16 23 12.866 23 8.99998C23 5.134 19.866 2 16 2C12.134 2 9 5.134 9 8.99998C9 12.866 12.134 16 16 16ZM7.5 18C5.56696 18 3.99994 19.567 4 21.5001L4.00001 22C4.00003 24.3935 5.52264 26.4174 7.68492 27.7934C9.85906 29.177 12.8015 30 15.9999 30C19.1983 30 22.1408 29.177 24.315 27.7934C26.4773 26.4174 28 24.3935 28 22V21.5C28 19.567 26.433 18 24.5 18H7.5Z" fill="${s}"/>
            </svg>
          `;case AvatarSize.SIZE_72:return t`
            <svg width="48" height="48" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M16 16C19.866 16 23 12.866 23 8.99998C23 5.134 19.866 2 16 2C12.134 2 9 5.134 9 8.99998C9 12.866 12.134 16 16 16ZM7.5 18C5.56696 18 3.99994 19.567 4 21.5001L4.00001 22C4.00003 24.3935 5.52264 26.4174 7.68492 27.7934C9.85906 29.177 12.8015 30 15.9999 30C19.1983 30 22.1408 29.177 24.315 27.7934C26.4773 26.4174 28 24.3935 28 22V21.5C28 19.567 26.433 18 24.5 18H7.5Z" fill="${s}"/>
            </svg>
          `}else if(e===AvatarImage.AAD)switch(C){case AvatarSize.SIZE_24:return t`
            <svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M4 1.5V3H8V1.5C8 1.22386 7.77614 1 7.5 1H4.5C4.22386 1 4 1.22386 4 1.5ZM3 3V1.5C3 0.671573 3.67157 0 4.5 0H7.5C8.32843 0 9 0.671573 9 1.5V3H10C11.1046 3 12 3.89543 12 5V5.5C12 6.32843 11.3284 7 10.5 7H7V6.5C7 6.22386 6.77614 6 6.5 6H5.5C5.22386 6 5 6.22386 5 6.5V7H1.5C0.671573 7 0 6.32843 0 5.5V5C0 3.89543 0.895431 3 2 3H3ZM0 7.50018V10C0 11.1046 0.89543 12 2 12H10C11.1046 12 12 11.1046 12 10V7.50018C11.5822 7.81403 11.0628 8 10.5 8H7V8.5C7 8.77614 6.77614 9 6.5 9H5.5C5.22386 9 5 8.77614 5 8.5V8H1.5C0.937197 8 0.41783 7.81403 0 7.50018Z" fill="${s}"/>
            </svg>
          `;case AvatarSize.SIZE_32:return t`
            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M7 5V3.75C7 2.7835 7.7835 2 8.75 2H11.25C12.2165 2 13 2.7835 13 3.75V5H14.5C15.8807 5 17 6.11929 17 7.5V8.5C17 9.32843 16.3284 10 15.5 10H11V9.5C11 9.22386 10.7761 9 10.5 9H9.5C9.22386 9 9 9.22386 9 9.5V10H4.5C3.67157 10 3 9.32843 3 8.5V7.5C3 6.11929 4.11929 5 5.5 5H7ZM8 5H12V3.75C12 3.33579 11.6642 3 11.25 3H8.75C8.33579 3 8 3.33579 8 3.75V5ZM3 10.5002V13.5C3 14.8807 4.11929 16 5.5 16H14.5C15.8807 16 17 14.8807 17 13.5V10.5002C16.5822 10.814 16.0628 11 15.5 11H11V11.5C11 11.7761 10.7761 12 10.5 12H9.5C9.22386 12 9 11.7761 9 11.5V11H4.5C3.9372 11 3.41783 10.814 3 10.5002Z" fill="${s}"/>
            </svg>
          `;case AvatarSize.SIZE_40:return t`
            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M10.25 3.5H13.75C14.1642 3.5 14.5 3.83579 14.5 4.25V6H9.5V4.25C9.5 3.83579 9.83579 3.5 10.25 3.5ZM8 4.25V6H6.25C4.45507 6 3 7.45507 3 9.25V10.75C3 11.7165 3.7835 12.5 4.75 12.5H10V12C10 11.4477 10.4477 11 11 11H13C13.5523 11 14 11.4477 14 12V12.5H19.25C20.2165 12.5 21 11.7165 21 10.75V9.25C21 7.45507 19.5449 6 17.75 6H16V4.25C16 3.00736 14.9926 2 13.75 2H10.25C9.00736 2 8 3.00736 8 4.25ZM21 13.4891C20.4949 13.8125 19.8943 14 19.25 14H14C14 14.5523 13.5523 15 13 15H11C10.4477 15 10 14.5523 10 14H4.75C4.10568 14 3.50515 13.8125 3 13.4891V16.75C3 18.5449 4.45507 20 6.25 20H17.75C19.5449 20 21 18.5449 21 16.75V13.4891Z" fill="${s}"/>
            </svg>
            `;case AvatarSize.SIZE_56:return t`
            <svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M13 5H19C19.5523 5 20 5.44772 20 6V8H12V6C12 5.44772 12.4477 5 13 5ZM10 6V8H7.5C5.01472 8 3 10.0147 3 12.5V14C3 15.6569 4.34315 17 6 17H13V16.5C13 15.6716 13.6716 15 14.5 15H17.5C18.3284 15 19 15.6716 19 16.5V17H26C27.6569 17 29 15.6569 29 14V12.5C29 10.0147 26.9853 8 24.5 8H22V6C22 4.34315 20.6569 3 19 3H13C11.3431 3 10 4.34315 10 6ZM13 19V19.5C13 20.3284 13.6716 21 14.5 21H17.5C18.3284 21 19 20.3284 19 19.5V19H26C27.1256 19 28.1643 18.6281 29 18.0004V23.5C29 25.9853 26.9853 28 24.5 28H7.5C5.01472 28 3 25.9853 3 23.5V18.0004C3.83566 18.6281 4.87439 19 6 19H13Z" fill="${s}"/>
            </svg>
            `;case AvatarSize.SIZE_64:return t`
            <svg width="38" height="38" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M13 5H19C19.5523 5 20 5.44772 20 6V8H12V6C12 5.44772 12.4477 5 13 5ZM10 6V8H7.5C5.01472 8 3 10.0147 3 12.5V14C3 15.6569 4.34315 17 6 17H13V16.5C13 15.6716 13.6716 15 14.5 15H17.5C18.3284 15 19 15.6716 19 16.5V17H26C27.6569 17 29 15.6569 29 14V12.5C29 10.0147 26.9853 8 24.5 8H22V6C22 4.34315 20.6569 3 19 3H13C11.3431 3 10 4.34315 10 6ZM13 19V19.5C13 20.3284 13.6716 21 14.5 21H17.5C18.3284 21 19 20.3284 19 19.5V19H26C27.1256 19 28.1643 18.6281 29 18.0004V23.5C29 25.9853 26.9853 28 24.5 28H7.5C5.01472 28 3 25.9853 3 23.5V18.0004C3.83566 18.6281 4.87439 19 6 19H13Z" fill="${s}"/>
            </svg>
          `;case AvatarSize.SIZE_72:return t`
            <svg width="48" height="48" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M13 5H19C19.5523 5 20 5.44772 20 6V8H12V6C12 5.44772 12.4477 5 13 5ZM10 6V8H7.5C5.01472 8 3 10.0147 3 12.5V14C3 15.6569 4.34315 17 6 17H13V16.5C13 15.6716 13.6716 15 14.5 15H17.5C18.3284 15 19 15.6716 19 16.5V17H26C27.6569 17 29 15.6569 29 14V12.5C29 10.0147 26.9853 8 24.5 8H22V6C22 4.34315 20.6569 3 19 3H13C11.3431 3 10 4.34315 10 6ZM13 19V19.5C13 20.3284 13.6716 21 14.5 21H17.5C18.3284 21 19 20.3284 19 19.5V19H26C27.1256 19 28.1643 18.6281 29 18.0004V23.5C29 25.9853 26.9853 28 24.5 28H7.5C5.01472 28 3 25.9853 3 23.5V18.0004C3.83566 18.6281 4.87439 19 6 19H13Z" fill="${s}"/>
            </svg>
          `}return null}renderImage(){return this.image===AvatarImage.NON_SIGN_IN||this.image===AvatarImage.MSA||this.image===AvatarImage.AAD?this.renderImageIcon(this.image,this.size):this.image?t`<img src="${this.image}" class="avatar-image" alt="avatar image"/>`:null}render(){this.style.setProperty("--avatar-color",this.getBackgroundColor());return t`
      <div class="container" style="--avatar-size: ${this.size}px;">
        ${(()=>this.badge&&this.size&&parseInt(this.size,10)>=56&&this.image!==AvatarImage.NON_SIGN_IN?t`
          <div class="badge">
            ${this.renderBadgeIcon(this.badge)}
          </div>
        `:null)()}
        ${this.renderImage()}
      </div>
    `}}),{role:"avatar"}));