# Dewey Hybrid Demo

This tutorial provides step-by-step instructions for setting up and running the Dewey Hybrid Demo.

## Prerequisites

- **Linux** with Python 3.8 or higher.
- If you are using **Windows**, you can use **WSL** with Ubuntu 22.04 LTS.

## Installation

1. Navigate to the `src` directory:
2. Install the required dependencies by running the following command:
   ```bash
   pip install -r components/edge_hybrid/tools/requirements.txt
   npm install -g live-server
   ```
## How to Use

1. Run the setup script using the following command:
   ```bash
   components/edge_hybrid/tools/setup.py run --no-browser
   ```
**[Optional]**

You might see `ERROR: System limit for number of file watchers reached`, it indicates that the file watcher is running out of handles. 
- The current limit can be viewed by
 `cat /proc/sys/fs/inotify/max_user_watches`
- This limit can be increased to its maximum by editing `/etc/sysctl.conf`
- and then you can adding this line to the end of the file: `fs.inotify.max_user_watches=524288`
- The new value can be loaded by running `sudo sysctl -p`

2. In the terminal, click the link to access the demo:
   ```
   http://127.0.0.1:8001
   ```

3. To use the Dewey Hybrid Demo, navigate to the following path in your browser:
   ```
   http://127.0.0.1:8001/common/dewey/dewey-hybrid-demo.html?testMode=true
   ```

4. Ensure `testMode=true` is set in the URL. Under test mode, you can switch the device type between **iOS** and **Android**.

## Note
- If you want to see the correct tokens, you need to add into `dewey/tokens/dewey-tokens.fonts.css` 
```
@import url('https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap');
@import url('https://fonts.cdnfonts.com/css/sf-pro-display');
```
