// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{getOsType as e}from"../environment.js";import{classMap as i,css as t,html as r,LitElement as a}from"../lit.js";import{MixinAttributes as o,MixinKeyEvent as c}from"./control-base.js";const s=t`
:host {
  position: relative;
  display: inline-block;
  width: 40px;
  height: 24px;
  -webkit-tap-highlight-color: transparent;
}

:host([disabled]) {
  opacity: 0.38;
}

.inner {
  position: absolute;
  width: 34px;
  height: 14px;
  left: 0;
  top: 0;
  right: 0;
  bottom: 0;
  margin: auto;
  border-radius: 8px;
  background-color: var(--icon-disabled);
  transition: all 250ms;
}

.inner.checked {
  background-color: var(--accent-primary);
  mix-blend-mode: normal;
  opacity: 0.5;
}

.handle {
  --size: 20px;
  box-sizing: border-box;
  position: absolute;
  width: var(--size);
  height: var(--size);
  border-radius: calc(var(--size) / 2);
  top: calc(50% - var(--size) / 2);
  left: 0px;
  background-color: var(--surfaces-tertiary);
  transition: all 250ms;
  box-shadow: 0px 2px 2px rgba(0, 0, 0, 0.14), 0px 3px 1px rgba(0, 0, 0, 0.12), 0px 1px 5px rgba(0, 0, 0, 0.2);
}

.handle.checked {
  left: unset;
  right: 0px;
  background-color: var(--accent-primary);
}

*:focus {
  outline: unset;
}

@media (prefers-color-scheme: dark) {
  .inner {
    background-color: var(--surfaces-secondary);
    opacity: 0.3;
  }
  .handle {
    background-color: var(--icon-secondary);
  }
}
`;const n=o(c(class extends a{static get properties(){return{checked:{type:Boolean},disabled:{type:Boolean,reflect:!0}}}static get styles(){return"android"===e()?s:t`
      :host {
        position: relative;
        display: inline-block;
        width: 52px;
        height: 32px;
        -webkit-tap-highlight-color: transparent;
      }

      :host(:active) > .handle:not(.disabled) {
        /* width: 30px; */
      }

      .inner {
        position: absolute;
        width: 100%;
        height: 100%;
        left: 0;
        top: 0;
        border-radius: 20px;
        background-color: var(--surfaces-tertiary);
        transition: all 100ms;
      }

      .inner.checked {
        background-color: var(--accent-shade-10);
      }

      .inner.checked.disabled {
        background-color: var(--accent-tint-20);
      }

      .handle {
        --size: 26px;
        box-sizing: border-box;
        position: absolute;
        width: var(--size);
        height: var(--size);
        border-radius: calc(var(--size) / 2);
        top: calc(50% - var(--size) / 2);
        left: 4px;
        background-color: #FFFFFF;
        transition: all 100ms;
      }

      .handle:not(.disabled:not(.checked)) {
        border: 0.5px solid rgba(0, 0, 0, 0.04);
      }

      .handle:not(.disabled) {
        box-shadow: 0px 3px 8px rgba(0, 0, 0, 0.15), 0px 3px 1px rgba(0, 0, 0, 0.06);
      }

      .handle.checked {
        left: unset;
        right: 4px;
      }

      *:focus {
        outline: unset;
      }

      @media (prefers-color-scheme: dark) {
        .inner {
          background-color: var(--surfaces-quaternary);
        }
        .inner.checked.disabled {
          background-color: var(--accent-tint-30);
        }
      }
    `}onClick(e){e.stopPropagation(),this.disabled||(this.checked=!this.checked,this.setAttribute("aria-checked",this.checked?"true":"false"),this.onChange&&this.onChange(this.checked))}connectedCallback(){super.connectedCallback(),this.addEventListener("click",this.onClick)}disconnectedCallback(){super.disconnectedCallback(),this.removeEventListener("click",this.onClick)}firstUpdated(){this.setAttribute("aria-checked",this.checked?"true":"false")}render(){return r`
      <div class=${i({inner:!0,checked:this.checked,disabled:this.disabled})}>
      </div>
      <div class=${i({handle:!0,checked:this.checked,disabled:this.disabled})}>
      </div>
    `}}),{role:"checkbox"});customElements.define("edge-switch",n);