// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{html as e,css as t,LitElement as i}from"../lit.js";import{MixinKeyEvent as o,MixinAttributes as r}from"./control-base.js";customElements.define("edge-checkbox",r(o(class extends i{constructor(){super(...arguments),this.onClick=e=>{e.stopPropagation(),this.disabled||(this.checked=!this.checked,this.setAttribute("aria-checked",this.checked?"true":"false"),this.onChange&&this.onChange(this.checked))}}static get properties(){return{checked:{type:Boolean,reflect:!0},disabled:{type:Boolean,reflect:!0}}}static get styles(){return t`
      :host {
        position: relative;
        display: inline-block;
        width: 24px;
        height: 24px;
        -webkit-tap-highlight-color: transparent;
      }

      .bg {
        position: absolute;
        width: 20px;
        height: 20px;
        border-radius: 3px;
        border-width: 1.5px;
        border-style: solid;
        border-color: var(--icon-secondary);
        box-sizing: border-box;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        margin: auto;
        transition: all 100ms;
      }

      :host([checked]) .bg {
        border-width: 0;
        background-color: var(--accent-shade-10);
      }

      :host([disabled]) .bg {
        border-color: var(--divider-primary);
      }

      :host([disabled][checked]) .bg {
        border-width: 0;
        background-color: var(--accent-tint-20);
      }

      svg {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        margin: auto;
        transition: all 100ms;
        opacity: 0;
        fill: var(--icon-accent);
      }

      :host([checked]) svg {
        opacity: 1;
      }

      @media (prefers-color-scheme: dark) {
        :host([disabled][checked]) .bg {
          background-color: var(--accent-tint-30);
        }
      }
    `}firstUpdated(){this.setAttribute("aria-checked",this.checked?"true":"false")}connectedCallback(){super.connectedCallback(),this.addEventListener("click",this.onClick)}disconnectedCallback(){super.disconnectedCallback(),this.removeEventListener("click",this.onClick)}render(){return e`
    <div class="bg"></div>
    <svg width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M10.265 3.20474C10.5661 3.48915 10.5797 3.96383 10.2953 4.26497L6.04526 8.76497C5.90613 8.91228 5.71332 8.99703 5.51071 8.99993C5.3081 9.00282 5.11295 8.92361 4.96967 8.78033L2.71967 6.53033C2.42678 6.23744 2.42678 5.76257 2.71967 5.46967C3.01256 5.17678 3.48744 5.17678 3.78033 5.46967L5.48463 7.17397L9.20474 3.23503C9.48915 2.9339 9.96383 2.92033 10.265 3.20474Z" />
    </svg>
    `}}),{role:"checkbox"}));