local basetype = require "venuscore.rtti.types.basetype"

local EventDelegateType = basetype:extend("EventDelegateType");

-- 签名
function EventDelegateType:new()
  EventDelegateType.super.new(self);
  self._infoList = {}; --
  -- inputInfoList不区分输入输出的 BlueFunctionPinInfo
  -- TODO(hhl) 都不用不序列化 反序列化的时候恢复
end

function EventDelegateType:SetArgsInfo(_argsInfo)
  self._infoList = _argsInfo
end

-- 用来生成 调用事件函数 节点
function EventDelegateType:GetArgsInfo()
  return self._infoList
end


-- Override
function EventDelegateType:isType(rhsType)

  if rhsType._infoList == nil then
    return false
  end

  if type(rhsType._infoList) ~= 'table' then
    return false
  end

  if #self._infoList ~= #rhsType._infoList then
    return false
  end

  for idx , rhsArg in ipairs(rhsType._infoList) do

    local selfArg = self._infoList[idx]

    -- FIXME(hhl) 未来这里要考虑继承
    local matched = selfArg:GetRtti():isType(rhsArg:GetRtti())
    if not matched then
      return false
    end
  end

  return true ;
end


function EventDelegateType:GetDisplayName()
  local name = "\nEventDelegateType:(\n"
  for idx, argInfo  in pairs(self._infoList) do
    local rtti = argInfo:GetRtti()
    if rtti.GetDisplayName then
      name = name .. rtti:GetDisplayName() .. ",\n"
    else
      name = name .. rtti:GetTypeName() .. ",\n"
    end
  end
  name = name .. ")"
  return name
end

-- EventDelegateType is abstract type
-- extend EventDelegateType is specific type

-- Override
function EventDelegateType:isTypeOrDriverType(rhsType)
  -- 继承目前只考虑 EventDelegateType
  if rhsType == EventDelegateType then
    return true
  end
  return self:isType(rhsType)
end

local newType = EventDelegateType:extend()
newType:SetArgsInfo({})
EventDelegateType.DEFAULT_DELEGATE_TYPE = newType;

return EventDelegateType;