local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "window.editor.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local CreateParamCommand = CommandBase:extend("CreateParamCommand");

function CreateParamCommand:new(comuid, paramInd)
    CreateParamCommand.super.new(self);
    self._comUid = comuid;
    self._UUID = ContentManager:GenerateUUID();
    self._paramInd = paramInd;
end

function CreateParamCommand:DoIt()
    self:BeginCmd();
    local ani = self:GetContent(self._comUid);
    if ani then
        local param = ani:CreateParameter(0, self._paramInd);
        if param then
            param:SetStaticID(self._UUID);
        end   
    end
    self:EndCmd();
end

function CreateParamCommand:Undo()
    self:BeginCmd();
    
    self:EndCmd();
end

return CreateParamCommand;