local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local thresholding = {}
thresholding.Ts = 0;

thresholding.Queue = 100;

function thresholding:Initialize(host, size)
  self.UNIFORM_THRESHOLD =apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"UNIFORM_THRESHOLD");
    
  self.Ts = host:CreateRenderObject("comm:documents/filter/material/thresholding.material");
  self.Ts:SetParameter(self.UNIFORM_THRESHOLD, mathfunction.vector1(0.5));
  return self.Queue;
end

function thresholding:Resizeview(size)
end

function thresholding:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.Ts:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.Ts:Draw(pipeline);
end

return thresholding;

