local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local stretchdistortion = {}
stretchdistortion.Sd = 0;

stretchdistortion.Queue = 120;


function stretchdistortion:Initialize(host, size)
    --<!--  set the offsets parameters in vertex shader -->
  self.Sd = host:CreateRenderObject("comm:documents/filter/material/stretchdistortion.material" );
  return self.Queue;
end

function stretchdistortion:Resizeview(size)
   self:_SetParam(size);
end

function stretchdistortion:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.Sd:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.Sd:Draw(pipeline);
end

return stretchdistortion;