local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local saturationfilter = {}
saturationfilter.Sf = 0;
saturationfilter.Queue = 112;



function saturationfilter:Initialize(host, size)
    --<!--  set the offsets parameters in vertex shader -->
  self.SATURATION = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"SATURATION");  
  self.Sf = host:CreateRenderObject("comm:documents/filter/material/saturationfilter.material" );
  self.Sf:SetParameter(self.SATURATION, mathfunction.vector1( 0.7 ) );
  --self:_SetParam(size);
  return self.Queue;
end

function saturationfilter:Resizeview(size)
  --self:_SetParam(size);
end

function saturationfilter:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.Sf:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.Sf:Draw(pipeline);
end

return saturationfilter;