local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local RadialBlur = {}
RadialBlur.Rb = 0;

RadialBlur.Queue = 123;



function RadialBlur:Initialize(host, size)
  
    --<!--  set the offsets parameters in vertex shader -->
  self.SPACE =apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"SPACE");
  self.Rb = host:CreateRenderObject("comm:documents/filter/material/radialblur.material" );
  self.Rb:SetParameter(self.SPACE, mathfunction.vector1(0.015));  --0.001~0.025 0.001步伐调试 
  return self.Queue;
end

function RadialBlur:Resizeview(size)
  self:_SetParam(size);
end

function RadialBlur:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.Rb:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.Rb:Draw(pipeline);
end

return RadialBlur;