local apolloengine = require "apolloengine"
local apollonode = require "apolloutility.apollonode"
local videodecet = require "videodecet"
local soundplayer = require "soundplayer"
local faceinfo = require "videodecet.faceinfo"
local mathfunction = require "mathfunction"
local math = require "math"
local venuscore = require "venuscore"
local posture = require "facecute.estimates.transposture";
local facecute = require "facecute"
local mlaamain={};

function mlaamain:Initialize(camera,config)
  
  self.maincamera = camera;
  self.post =  self.maincamera:CreatePostEffect();
  local mlaapath = "comm:script/apolloengine/posteffect";
  self.post:CreateResource(mlaapath.."/mlaa.lua"); 
  
  local tex = apolloengine.TextureEntity();
  local path ="comm:/documents";
  local imagePath = path.."/texture/mlaa/areamap32.png";
  tex:PushMetadata(apolloengine.TextureFileMetadata(apolloengine.TextureEntity.TU_STATIC,
      apolloengine.TextureEntity.PF_AUTO,1, false,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TF_NEAREST,
      apolloengine.TextureEntity.TF_NEAREST,
      imagePath));
  local res = tex:CreateResource();
  self.tex = tex;
  self.blwmaterialpath = path.."/material/blendweight.material";
  self.post:RegisterParameter("TEXTURE_AREAMAP", self.blwmaterialpath);
  self.post:TEXTURE_AREAMAP(self.tex);
  
  
end


function mlaamain:SetParameterValue(slotname, material,value)
  local ps = apolloengine.IMaterialSystem:GetParameterSlot(slotname);
  local roe = self.post.post:GetRenderObject(material);
  roe:SetParameter(ps, value);
 
end

function mlaamain:Update(def)
end

function mlaamain:OnRecordStart()
end

function mlaamain:Exit()
  self.post:Disable();
  self.maincamera:DeletePostEffect(self.post);
end

return mlaamain;