local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local fainted = {}
fainted.Ft = 0;
fainted.Queue = 118;


function fainted:Initialize(host, size)  
    --<!--  set the offsets parameters in vertex shader -->
  self.COUNT = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"COUNT"); 
  self.MAX_BIAS = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"MAX_BIAS");   
  self.SPEED = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"SPEED");   
  self.Ft = host:CreateRenderObject("comm:documents/filter/material/fainted.material" );
  self.Ft:SetParameter(self.COUNT, mathfunction.vector1(0.0));
  self.Ft:SetParameter(self.MAX_BIAS, mathfunction.vector1(0.05));
  self.Ft:SetParameter(self.SPEED, mathfunction.vector1(0.5));
  return self.Queue;
end

function fainted:Resizeview(size)
  --self:_SetParam(size);
end

function fainted:Process(pipeline, Original, Scene, Output)  
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.Ft:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.Ft:Draw(pipeline);
end

return fainted;