local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local contrastfilter = {}
contrastfilter.Cf = 0;
contrastfilter.Queue = 111;



function contrastfilter:Initialize(host, size)
    --<!--  set the offsets parameters in vertex shader -->
  self.CONTRAST = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"CONTRAST");  
  self.Cf = host:CreateRenderObject("comm:documents/filter/material/contrastfilter.material" );
  self.Cf:SetParameter(self.CONTRAST, mathfunction.vector1(0.5));
  --self:_SetParam(size);
  return self.Queue;
end

function contrastfilter:Resizeview(size)
  --self:_SetParam(size);
end

function contrastfilter:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.Cf:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.Cf:Draw(pipeline);
end

return contrastfilter;