local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local bulgedistortion = {}
bulgedistortion.Bd = 0;

bulgedistortion.Queue = 117;

function bulgedistortion:_SetParam(size)  -- fortest
  self.height= size:y();
  self.width=size:x();
  self.Bd:SetParameter(self.ASPECT_RATIO, mathfunction.vector1( self.width/self.height ) );
end


function bulgedistortion:Initialize(host, size)
    --<!--  set the offsets parameters in vertex shader -->
  self.RADIUS = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"RADIUS"); 
  self.SCALE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"SCALE"); 
  self.ASPECT_RATIO = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"ASPECT_RATIO"); 
  self.Bd = host:CreateRenderObject("comm:documents/filter/material/bulgedistortion.material" );
  self:_SetParam(size);
  self.Bd:SetParameter(self.RADIUS, mathfunction.vector1( 0.5 ) );
  self.Bd:SetParameter(self.SCALE, mathfunction.vector1( 0.5 ) );
  return self.Queue;
end

function bulgedistortion:Resizeview(size)
   self:_SetParam(size);
end

function bulgedistortion:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.Bd:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.Bd:Draw(pipeline);
end

return bulgedistortion;