local BlueNode = require "bluecore.bluenode"
local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"

local Acos = BlueNode:extend();

---- 游戏运行模式
function Acos:new(...)
  Acos.super.new(self, ...)
end

function Acos:_OnUpdate(args)

  local res = math.acos(args[1]);
  return res, res*180.0/math.pi;

end

---- 编辑器模式

Acos:RegisterInput(1, Types.FloatType, "val", "[1]", 0);
Acos:RegisterOutput(1, Types.FloatType, "rad", "反余弦结果(弧度)");
Acos:RegisterOutput(2, Types.FloatType, "angle", "反余弦结果(角度)");
Acos:SetFunctionName("Acos");
Acos:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return Acos;

