local mf = require "mathfunction"
local BD = require "bluecore.bluedefined"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"
local Vec3MultiQuaternion = BlueNode:extend();

---- 游戏运行模式
function Vec3MultiQuaternion:new(...)
  Vec3MultiQuaternion.super.new(self, ...)
end

function Vec3MultiQuaternion:_OnUpdate(args)
  local one = args[1] ;
  local two = args[2] ;
  return one * two ;
end

---- 编辑器模式

Vec3MultiQuaternion:RegisterInput(1, mf.vector3:RTTI(), "vector3", "向量(x,y,z)", mf.vector3(1.0,1.0,1.0));
Vec3MultiQuaternion:RegisterInput(2, mf.Quaternion:RTTI(), "Quatenion", "四元数", mf.Quaternion());
Vec3MultiQuaternion:RegisterOutput(1, mf.vector3:RTTI(), "multi", "向量四元数乘 scale * quatenion(x,y,z,w)");
Vec3MultiQuaternion:SetFunctionName("vector3 * quatenion");
Vec3MultiQuaternion:SetFunctionType(BD.STATIC_FUNCTION_NODE);


return Vec3MultiQuaternion;