local mf = require "mathfunction"
local BD = require "bluecore.bluedefined"
local BlueNode = require "bluecore.bluenode"
local Vec2MinusVec2 = BlueNode:extend();

---- 游戏运行模式
function Vec2MinusVec2:new(...)
  Vec2MinusVec2.super.new(self, ...)
end

function Vec2MinusVec2:_OnUpdate(args)
  local one = args[1] ;
  local two = args[2] ;
  return one - two ;
end

---- 编辑器模式

Vec2MinusVec2:RegisterInput(1, mf.vector2:RTTI(), "1", "向量(x,y,z)", mf.vector2(0.0,0.0));
Vec2MinusVec2:RegisterInput(2, mf.vector2:RTTI(), "2", "向量(x,y,z)", mf.vector2(0.0,0.0));
Vec2MinusVec2:RegisterOutput(1, mf.vector2:RTTI(), "-", "相减(x,y,z)");
Vec2MinusVec2:SetFunctionName("vec2-vec2");
Vec2MinusVec2:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return Vec2MinusVec2;