local BD = require "bluecore.bluedefined"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"

local Divide = BlueNode:extend();

---- 游戏运行模式
function Divide:new(...)
  Divide.super.new(self, ...)

end

function Divide:_OnUpdate(args)
  local x,y = math.modf(args[1]/args[2]) -- 与C++保持一致 往0靠近
  return x --
end

---- 编辑器模式
Divide:RegisterInput(1, Types.IntType, "1", "[1]", 1);
Divide:RegisterInput(2, Types.IntType, "2", "[2]", 1);

Divide:RegisterOutput(1, Types.IntType, "/", "整除结果");

Divide:SetFunctionName("/");
Divide:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return Divide;