local BlueDefined = require "bluecore.bluedefined"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"


local Abs = BlueNode:extend();

---- 游戏运行模式
function Abs:new(...)
  Abs.super.new(self, ...)
end

function Abs:_OnUpdate(args)
  return math.abs(args[1]);
end

---- 编辑器模式
Abs:RegisterInput(1, Types.IntType, "1", "[1]", -1);

Abs:RegisterOutput(1, Types.IntType, "abs", "绝对值");

Abs:SetFunctionName("|a|");
Abs:SetFunctionType(BlueDefined.STATIC_FUNCTION_NODE);

return Abs;

