local BD = require "bluecore.bluedefined"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"
local Equal = BlueNode:extend();
local RM = require "venuscore.rtti.rttimanager"
local CObjectRtti = RM:GetRtti("Object");

-- C++/Lua object equal
function Equal:new(...)
  Equal.super.new(self, ...)
end

function Equal:_OnUpdate(args)
  return args[1] ~= nil and args[2] ~= nil and args[1] ==  args[2]
end

-- NotNullType() 两个引脚都不能悬空
Equal:RegisterInput(1, CObjectRtti, "1", "[1]", Types.NotNullType());
Equal:RegisterInput(2, CObjectRtti, "2", "[2]", Types.NotNullType());

Equal:RegisterOutput(1, Types.BoolType, "==", "result");

Equal:SetFunctionName("==");
Equal:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return Equal ;

