local BN = require "bluecore.bluenode"
local DoN = BN:extend();

local Types = require "venuscore.rtti.types"

function DoN:new(...)
  DoN.super.new(self, ...)
  self.current = 1
end

function DoN:Update(execIdx)
  if execIdx == 2 then
    return self:_Reset();
  elseif execIdx == 1 then
    return self:_Loop();
  end
  -- if get output only, execIdx is nil
end

function DoN:_Reset()
  if _KRATOSEDITOR then
    local BuEd = require "bluecore.editor.blueutility_ed"
    BuEd:BlueDebugYield(self);
  end
  self.current = 1 ;
  return nil
end

function DoN:_Loop()

  if self.isRunning then
    LOG("[DoN:Update] is running");
    return nil
  end
  self.isRunning = true ;

  local args = self:_GetInput()
  local loopNum = args[1]

  if _KRATOSEDITOR then
    local BuEd = require "bluecore.editor.blueutility_ed"
    BuEd:BlueDebugYield(self);
  end

  if self.nextExecNodes[1] ~= nil then
    for k = 1, loopNum do
      self.current = k
      local lastNode = self
      local execIdx = 1
      local nextNode = self.nextExecNodes[execIdx];
      local nextIdx = self.nextExecIndex[execIdx]
      while nextNode ~= nil do
        if _KRATOSEDITOR then
          local linkUid = lastNode.execOutputs[execIdx].links[1].linkUid;
          self.graph:AddExecLinkList(linkUid);
        end
        lastNode = nextNode
        execIdx  = nextNode:Update(nextIdx)
        nextIdx  = nextNode.nextExecIndex[execIdx]
        nextNode = nextNode.nextExecNodes[execIdx]
      end
    end
  end

  self.isRunning = false ;
  return
end

function DoN:GetOutputByIndex(index)
  return self.current
end

DoN:RegisterInput( 1, Types.IntType, "N", "loop number", 2);
DoN:RegisterOutput(1, Types.IntType, "Counter", "current index(start from 1)");

DoN:RegisterExecInput(1, "Exec", "Enter");
DoN:RegisterExecInput(2, "Reset", "Reset(NOT Exit)");

DoN:RegisterExecOutput(1, "Loop", "Exit");

DoN:SetFunctionName("Do N");

return DoN ;

