
local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"

local GetTransformComponent = BlueNode:extend();

---- 游戏运行模式
function GetTransformComponent:new(...)
	GetTransformComponent.super.new(self,...)
end

function GetTransformComponent:_OnUpdate(args)
	local node_target = args[1] ;
	return node_target:GetComponent(apolloengine.Node.CT_TRANSFORM)
end

---- 编辑器模式

GetTransformComponent:RegisterInput(1, apolloengine.Node:RTTI(), "target", "target指向场景中的node", BlueSelf());

GetTransformComponent:RegisterOutput(1, apolloengine.TransformComponent:RTTI(), "component", "返回对应的Component/组件对象");

GetTransformComponent:SetFunctionName("GetTransformComponent");

return GetTransformComponent ;