
local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local BlueSelf = require "bluecore.blueself"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"

local GetComponent = BlueNode:extend();

---- 游戏运行模式
function GetComponent:new(...)
	GetComponent.super.new(self,...);
end

function GetComponent:_OnUpdate(args)
	local node_target = args[1] ;
	local content_type = args[2] ;
	return node_target:GetComponent(content_type)
end


---- 编辑器模式


GetComponent:RegisterInput(1, apolloengine.Node:RTTI(), "target", "target指向场景中的node", BlueSelf());
GetComponent:RegisterInput(2, Types.ComponentType, "content_type", "需要从node中获取的Component的类型", 7);

GetComponent:RegisterOutput(1, apolloengine.IComponent:RTTI(), "component", "返回对应的Component/组件对象");

GetComponent:SetFunctionName("GetComponent");

return GetComponent ;