local apolloengine = require "apolloengine"
local BlueSelf = require "bluecore.blueself"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"
local BD = require "bluecore.bluedefined"

local GetActive = BlueNode:extend();

---- 游戏运行模式
function GetActive:new(...)
	GetActive.super.new(self,...);
end

function GetActive:_OnUpdate(args)
	if args[1] ~= nil  then
		return args[1].Active
	else
		return false
	end
end

---- 编辑器模式

--在根节点设置子节点active状态实现场景切换
GetActive:RegisterInput(1, apolloengine.Node:RTTI(), "target", "node", BlueSelf());
GetActive:RegisterOutput(1, Types.BoolType, "active", "node active?");

GetActive:SetFunctionType(BD.STATIC_FUNCTION_NODE);
GetActive:SetFunctionName("Get Active");

return GetActive;