local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"

local GetWorldPositionVec3 = BlueNode:extend();

---- 游戏运行模式
function GetWorldPositionVec3:new(...)
  GetWorldPositionVec3.super.new(self, ...)
end

function GetWorldPositionVec3:_OnUpdate(args)
  local transformComponent_target = args[1];
  local result = transformComponent_target:GetWorldPosition();
  return result;
end

---- 编辑器模式

GetWorldPositionVec3:RegisterOutput(1,  mathfunction.vector3:RTTI(), "vec3", "向量");
GetWorldPositionVec3:RegisterInput(1, apolloengine.TransformComponent:RTTI(), "target", "TransformComponent组件", BlueSelf());
GetWorldPositionVec3:SetFunctionName("GetWorldPosition(Vec3)");

return GetWorldPositionVec3;