local mathfunction = require "mathfunction"
local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"
local SetScriptValue = require "bluecore.base.set_script_value"
local SetScriptVector3 = SetScriptValue:extend();


---- 游戏运行模式
function SetScriptVector3:new(...)
  SetScriptVector3.super.new(self, ...)

end

function SetScriptVector3:_OnUpdate(args)

  local scriptIns = args[1];
  local para = args[2];  
  --scriptIns[para] = args[3];
  scriptIns:SetScriptValue(para, args[3]);
end



function SetScriptVector3:_IsRightType(key, value, scriptIns)
  return type(value) == "userdata" and value:RTTI() == mathfunction.vector3():RTTI();
end



SetScriptVector3:RegisterInput(1, Types.ScriptInsRefType, "Script_Instance", "behaviour", Types.NotNullType());
SetScriptVector3:RegisterInput(2, Types.ComboType, "ParaName", "参数名字", BD.EMPTY_STRING); --instance可选的vector3变量
SetScriptVector3:RegisterInput(3, mathfunction.vector3:RTTI(), "ParaValue", "参数值", mathfunction.vector3(1.0,1.0,1.0));


SetScriptVector3:RegisterExecInput(1, "exec", "执行");

SetScriptVector3:RegisterExecOutput(1, "exec", "执行");

SetScriptVector3:SetFunctionName("SetScriptVector3");


return SetScriptVector3 ;

