
local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local BlueSelf = require "bluecore.blueself"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"
local BD = require "bluecore.bluedefined"
local BU = require "bluecore.blueutility"

local GetReservedFbo = BlueNode:extend();

function GetReservedFbo:new(...)
    GetReservedFbo.super.new(self,...);
end

function GetReservedFbo:_OnUpdate(args)
    local reservedFbo = args[1]:GetReserveFrames();
    local reservedTex = args[1]:GetReserveTextures();
    if not reservedFbo and not reservedTex then
      return nil, nil;
    else
      return reservedFbo, reservedTex;
    end
end


GetReservedFbo:RegisterInput(1, apolloengine.CameraComponent:RTTI(), "target", "相机组件", BlueSelf());
GetReservedFbo:RegisterOutput(1, BU:GetArrayRtti( apolloengine.RenderTargetEntity:RTTI() ) , "FBO", "相机的历史FBO");
GetReservedFbo:RegisterOutput(2, BU:GetArrayRtti( apolloengine.TextureEntity:RTTI() ), "Tex", "所有历史FBO绑定的纹理");
GetReservedFbo:SetFunctionName("GetReservedFbo");
GetReservedFbo:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return GetReservedFbo;