local liquifyconfig = require "behavior3.liquify_config"
local mathfunction = require "mathfunction"

local Function = {};

Function.GetPlaneCoor = {
    ["human"] = function (faceIndex, all_lmks, ws)
        local left_eye_point = 74;
        local right_eye_point = 77;
        local in_between_eyes_point = 43;
        local upper_lip_point = 87;
        local middle_nose = 45;
        local offset = faceIndex * liquifyconfig.subject["human"].num_lmks;
        local dx = all_lmks[offset + right_eye_point + 1] -  all_lmks[offset + left_eye_point +1];
        local lengthX = dx:Length();
        local dy = (all_lmks[offset + in_between_eyes_point + 1] - all_lmks[offset + middle_nose + 1])*2.6;
        local y_unit_axis = mathfunction.vector2(-dx.my/lengthX,dx.mx/lengthX);
        local lengthY = dy:Dot(y_unit_axis);
        dy = y_unit_axis*lengthY;

        local point = all_lmks[offset+in_between_eyes_point+1]+dx*ws[1]+dy*ws[2];
        return point;
    end,
    ["cat"] = function (faceIndex, all_lmks, ws)
        local left_eye_point = 16;
        local right_eye_point = 21;
        local middle_nose = 23;
        local offset = faceIndex * liquifyconfig.subject["cat"].num_lmks;
        local dx = all_lmks[offset + right_eye_point + 1] - all_lmks[offset + left_eye_point + 1];
        local lengthX = dx:Length();
        local in_between_eyes_point_coord = mathfunction.vector2((all_lmks[offset + right_eye_point + 1].mx + all_lmks[offset + left_eye_point + 1].mx) / 2.0,
            (all_lmks[offset + right_eye_point + 1].my + all_lmks[offset + left_eye_point + 1].my) / 2.0);
        local dy = (in_between_eyes_point_coord - all_lmks[offset + middle_nose + 1]) * 2.6;
        local y_unit_axis = mathfunction.vector2(-dx.my/lengthX, dx.mx/lengthX);
        local lengthY = dy:Dot(y_unit_axis);
        dy = y_unit_axis*lengthY;

        local point = in_between_eyes_point_coord + dx*ws[1] + dy*ws[2];
        return point;
    end
}

Function.GetFaceDirXAndRadiusRatio = {
    ["human"] = function (faceIndex, coefX, coefY, half_width, recogResult)
        local innercanthus_left = 55;
		local outercanthus_left = 52;
		local innercanthus_right = 58;
		local outercanthus_right = 61;
		local left_eye_point = 74;
		local right_eye_point = 77;
		local in_between_eyes_point = 43;
		local middle_nose = 45;
        local upper_lip_point = 87;
        local all_lmks = recogResult.all_lmks;
        
        local offset = faceIndex * liquifyconfig.subject["human"].num_lmks;
        local incrX = (all_lmks[offset+innercanthus_left+1]-all_lmks[offset+innercanthus_right+1]):Length();
        incrX = incrX + (all_lmks[offset+outercanthus_left+1]-all_lmks[offset+outercanthus_right+1]):Length();
        local lengthX = incrX/2;
        local lengthY = 2.5 * (all_lmks[offset+in_between_eyes_point+1]-all_lmks[offset+middle_nose+1]):Length();
        local ms_faceDirX = (all_lmks[offset+right_eye_point]-all_lmks[offset+left_eye_point]):Normalize();
        local ms_radiusRatio = mathfunction.vector2(lengthX*coefX/half_width,lengthY*coefY/half_width);

        -- flip y axis, because shader in faceliquify is flipped
        ms_faceDirX.my = -ms_faceDirX.my;

        return ms_faceDirX, ms_radiusRatio;
    end,
    ["cat"] = function (faceIndex, coefX, coefY, half_width, recogResult)
        local left_eye_point = 16;
        local right_eye_point = 21;
        local innercanthus_left = 14;
        local outercanthus_left = 12;
        local innercanthus_right = 17;
        local outercanthus_right = 19;
        local middle_nose = 23;
        local all_lmks = recogResult.all_lmks;
        local offset = faceIndex * liquifyconfig.subject["cat"].num_lmks;
        local in_between_eyes_point_coord = mathfunction.vector2((all_lmks[offset + right_eye_point + 1].mx + all_lmks[offset + left_eye_point + 1].mx) / 2.0,
            (all_lmks[offset + right_eye_point + 1].my + all_lmks[offset + left_eye_point + 1].my) / 2.0);
        
        local incrX = (all_lmks[offset+innercanthus_left+1]-all_lmks[offset+innercanthus_right+1]):Length();
        incrX = incrX + (all_lmks[offset+outercanthus_left+1]-all_lmks[offset+outercanthus_right+1]):Length();
        local lengthX = incrX/2;
        local lengthY = 2.5 * (in_between_eyes_point_coord-all_lmks[offset+middle_nose+1]):Length();
        local ms_faceDirX = (all_lmks[offset+right_eye_point]-all_lmks[offset+left_eye_point]):Normalize();
        local ms_radiusRatio = mathfunction.vector2(lengthX*coefX/half_width,lengthY*coefY/half_width);

        ms_faceDirX.my = -ms_faceDirX.my;

        return ms_faceDirX, ms_radiusRatio;
    end
}

Function.GetScaleRatios = {
    ["human"] = function (faceIndex, intensityX, intensityY, recogResult)
        local all_pry = recogResult.all_pry;
        local smooth_factor = math.cos(all_pry[faceIndex*3+2]*math.pi/180);
        local ms_scaleRatioX = mathfunction.vector1(1+(intensityX-1)*smooth_factor);
        local ms_scaleRatioY = mathfunction.vector1(1+(intensityY-1)*smooth_factor);
        return ms_scaleRatioX, ms_scaleRatioY;
    end,
    ["cat"] = function (faceIndex, intensityX, intensityY, recogResult)
        -- local all_pry = recogResult.all_pry;
        -- local smooth_factor = math.cos(all_pry[faceIndex*3+2]*math.pi/180);
        local smooth_factor = 1.0;
        local ms_scaleRatioX = mathfunction.vector1(1+(intensityX-1)*smooth_factor);
        local ms_scaleRatioY = mathfunction.vector1(1+(intensityY-1)*smooth_factor);
        return ms_scaleRatioX, ms_scaleRatioY;
    end
}

return Function;