local b3 = require 'behavior3.b3';
require 'behavior3.core.Composite'

local memSequence = b3.Class("MemSequence", b3.Composite)
b3.MemSequence = memSequence

function memSequence:ctor()
	--b3.MemSequence.ctor(self)
  b3.Composite.ctor(self)

	self.name = "MemSequence"
end

function memSequence:init(tick)
	tick.nodestage:set("runningChild", 0, tick.tree.id, self.id)
  b3.BaseNode.init(self, tick)
end

function memSequence:tick(tick)
	local child = tick.nodestage:get("runningChild", tick.tree.id, self.id)

	for i,v in ipairs(self.children) do
    repeat
      if i < child then
        break;
      end
      local status = v:_execute(tick)

      if status ~= b3.SUCCESS then
        if status == b3.RUNNING then
          tick.nodestage:set("runningChild", i, tick.tree.id, self.id)
        else
          tick.nodestage:set("runningChild", 0, tick.tree.id, self.id)
        end
        return status
      end
    until true
	end
  
  tick.nodestage:set("runningChild", 0, tick.tree.id, self.id)
	return b3.SUCCESS
end

function memSequence:reset(tick)
  tick.nodestage:set("runningChild", 0, tick.tree.id, self.id)
  b3.BaseNode.reset(self, tick)
end
