
local ae = require "apolloengine"
local mf = require "mathfunction"

local threshold = {}

function threshold:Initialize(host, size)
  self.renderObject = nil
  self.Queue = 100
        
  self.Threshold = mf.vector1(128.0);

  self.POST_EFFECT_ALPHA = ae.IMaterialSystem:NewParameterSlot(
    ae.ShaderEntity.UNIFORM,
    "POST_EFFECT_ALPHA");
  
  self.renderObject = host:CreateRenderObject("comm:documents/shaders/posteffect/threshold.material");

  self.renderObject:SetParameter(self.POST_EFFECT_ALPHA, mf.vector1(1.0));
  
  host:RegisterScriptParameter(self, "Threshold");
  
  return self.Queue
end

function threshold:Resizeview(size)
end

function threshold:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget()
  Output:ClearBuffer(ae.RenderTargetEntity.CF_COLOR)

  local materials = self.renderObject.MaterialEntities;
  local material = materials[1];
    
  material:SetParameter(
          "_MainTex",
          Scene:GetAttachment(ae.RenderTargetEntity.TA_COLOR_0));
  
  material:SetParameter("_Threshold", mf.vector1(math.max(math.min(self.Threshold:x() / 255.0,1.0),0.0)) );
  
  self.renderObject:Draw(pipeline)
end


return threshold;