require "utility"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local videodecet = require "videodecet"

local nasolabial = {}

nasolabial.renderObject = nil;
nasolabial.queue = 100;
nasolabial.mask = nil;
nasolabial.strengh = 0.5;
nasolabial.brightscale = 8;

function nasolabial:Initialize(host, size)
  self.Stepsize1 = mathfunction.vector2(5, 5);
  self.Stepsize2 = mathfunction.vector2(3, 3);
  
  self.GuassStep1 = self.Stepsize1 / size;
  self.GuassStep2 = self.Stepsize2 / size;
  
  self.GAUSSIAN_STEP = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "GAUSSIAN_STEP");
  self.GAUSSUAN_COORDNATE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.INTERNAL,
      "GAUSSUAN_COORDNATE");
  
  self.TEXTURE_MASK = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_MASK");
  self.TEXTURE_BLUR1 = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_BLUR1");
  self.UNIFORM_STRENGTH = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "UNIFORM_STRENGTH");
  self.UNIFORM_BRIGHTSCALE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "UNIFORM_SCALE");
  
    
  local GuassStep1 = self.Stepsize1 / size;
  local GuassStep2 = self.Stepsize2 / size;
  self.GuassX = host:CreateRenderObject( "comm:documents/material/gaussianblur.material" );
  self.GuassX:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep1:x(), 0) );
  
  self.GuassY = host:CreateRenderObject( "comm:documents/material/gaussianblur.material" );
  self.GuassY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, GuassStep1:y()) );
  
  self.Blend = host:CreateRenderObject( "docs:beauty/material/nasolabial.material" );
  self.Blend:SetParameter( self.UNIFORM_STRENGTH, mathfunction.vector1(self.strengh) );
  self.Blend:SetParameter( self.UNIFORM_BRIGHTSCALE, mathfunction.vector1(self.brightscale) );
  
  self.blurXRT = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_A, size );
  self.blurRT1 = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_B, size );
  return self.queue;
end

function nasolabial:Resizeview(size)
  self.GuassStep1 = self.Stepsize1 / size;
  self.GuassStep2 = self.Stepsize2 / size;
  self.size = size;
  
end

function nasolabial:Process(pipeline, Original, Scene, Output)
  
  self:_UpdateParameters();
  
  self.GuassX:SetParameter(self.GAUSSIAN_STEP, mathfunction.vector2( self.GuassStep1:x(), 0) );
  self.blurXRT:PushRenderTarget();
	self.blurXRT:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
	self.GuassX:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));
	self.GuassX:Draw(pipeline);
  
  self.GuassY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, self.GuassStep1:y()) );
  self.blurRT1:PushRenderTarget();
  self.blurRT1:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.GuassY:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.blurXRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.GuassY:Draw(pipeline);
  
  Output:PushRenderTarget();
  Output:ClearBuffer(apolloengine.RenderTargetEntity.TA_COLOR_0);
  
  local blurtexture1 = self.blurRT1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 )
  local origintexture =  Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 )
  self.Blend:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,origintexture);
  self.Blend:SetParameter(self.TEXTURE_MASK,self.mask);
  self.Blend:SetParameter(self.TEXTURE_BLUR1,blurtexture1);
  
  self.Blend:Draw(pipeline);
  
end

function nasolabial:_UpdateParameters()
  LOG("STRENGTH"..self.strengh);
  self.Blend:SetParameter( self.UNIFORM_STRENGTH, mathfunction.vector1(self.strengh));
end

return nasolabial;