local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

local Mopi = {}
Mopi.Do = 0;
Mopi.Queue = 310;

function Mopi:Initialize(host, size)

    self.sigma_r = mathfunction.vector1(0.3);
   
    self.TARGETSIZE = apolloengine.IMaterialSystem:NewParameterSlot(
            apolloengine.ShaderEntity.UNIFORM,
            "iResolution");
  
    self.SIGMA_R = apolloengine.IMaterialSystem:NewParameterSlot(
            apolloengine.ShaderEntity.UNIFORM,
            "BSIGMA");

  local pathout = venuscore.IFileSystem:PathAssembly("comm:documents/material/mopi.material");
  self.Do = host:CreateRenderObject(pathout);
  self.Do:SetParameter(self.TARGETSIZE,size);
  self.Do:SetParameter(self.SIGMA_R, self.sigma_r);
  
  host:RegisterScriptParameter(self,"sigma_r");

  return self.Queue;
end



function Mopi:Resizeview(size)
    self.Do:SetParameter(self.TARGETSIZE,size);
end

function Mopi:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.Do:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );

  self.Do:SetParameter(self.SIGMA_R, self.sigma_r);
  self.Do:Draw(pipeline);
end

return Mopi;