local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

local LightDot = {}
LightDot.Do = 0;
LightDot.Queue = 310;

function LightDot:Initialize(host, size)
  self.uv_dotRadius = mathfunction.vector1(0.0);
  self.uv_dotInternal = mathfunction.vector1(0.0);
  self.angle_channel = mathfunction.vector1(0.0);
  self.contrastFactor = mathfunction.vector1(0.0);
  self.half_toneFactor = mathfunction.vector1(0.0);
  self.SourceTex     = apolloengine.TextureEntity();
  self.soft_lightAlpha = mathfunction.vector1(0.0);
  self.threshold = mathfunction.vector1(0.0);
  self.gradient = mathfunction.vector1(2.0);

  self.TARGETSIZE = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "TARGETSIZE");
  self.UV_DOT_RADIUS = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "UV_DOT_RADIUS");
  self.UV_DOT_INTERNAL = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "UV_DOT_INTERNAL");
  self.ANGLE_CHANNEL = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "ANGLE_CHANNEL");
  self.CONTRAST_FACTOR = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "CONTRAST_FACTOR");
  self.HALF_TONE_FACTOR = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "HALF_TONE_FACTOR");

  self.TEXTURE_DIFFUSE2 = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "TEXTURE_DIFFUSE2");

  self.SOFT_LIGHT_ALPHA = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "SOFT_LIGHT_ALPHA");
  self.THRESHOLD = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "THRESHOLD");
  self.GRADIENT = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "GRADIENT");


  local pathout = venuscore.IFileSystem:PathAssembly("comm:documents/material/light_dot.material");
  self.Do = host:CreateRenderObject(pathout);

  self.Do:SetParameter(self.TARGETSIZE,size);
  self.Do:SetParameter(self.UV_DOT_RADIUS, self.uv_dotRadius);
  self.Do:SetParameter(self.UV_DOT_INTERNAL, self.uv_dotInternal);
  self.Do:SetParameter(self.ANGLE_CHANNEL, self.angle_channel);
  self.Do:SetParameter(self.CONTRAST_FACTOR, self.contrastFactor);
  self.Do:SetParameter(self.HALF_TONE_FACTOR, self.half_toneFactor);
  self.Do:SetParameter(self.TEXTURE_DIFFUSE2, self.SourceTex);
  self.Do:SetParameter(self.SOFT_LIGHT_ALPHA, self.soft_lightAlpha);
  self.Do:SetParameter(self.THRESHOLD, self.threshold);
  self.Do:SetParameter(self.GRADIENT, self.gradient);

  host:RegisterScriptParameter(self,"uv_dotRadius");
  host:RegisterScriptParameter(self,"uv_dotInternal");
  host:RegisterScriptParameter(self,"angle_channel");
  host:RegisterScriptParameter(self,"contrastFactor");
  host:RegisterScriptParameter(self,"half_toneFactor");
  host:RegisterScriptParameter(self, "SourceTex");
  host:RegisterScriptParameter(self, "soft_lightAlpha");
  host:RegisterScriptParameter(self, "threshold");
  host:RegisterScriptParameter(self, "gradient");
  return self.Queue;
end



function LightDot:Resizeview(size)
  self.Do:SetParameter(self.TARGETSIZE,size);
end

function LightDot:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.Do:SetParameter(
          apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
          Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );

  self.Do:SetParameter(self.UV_DOT_RADIUS, self.uv_dotRadius);
  self.Do:SetParameter(self.UV_DOT_INTERNAL, self.uv_dotInternal);
  self.Do:SetParameter(self.ANGLE_CHANNEL, self.angle_channel);
  self.Do:SetParameter(self.CONTRAST_FACTOR, self.contrastFactor);
  self.Do:SetParameter(self.HALF_TONE_FACTOR, self.half_toneFactor);
  self.Do:SetParameter(self.TEXTURE_DIFFUSE2, self.SourceTex);
  self.Do:SetParameter(self.SOFT_LIGHT_ALPHA, self.soft_lightAlpha);
  self.Do:SetParameter(self.THRESHOLD, self.threshold);
  self.Do:SetParameter(self.GRADIENT, self.gradient);
	self.Do:Draw(pipeline);
end

return LightDot;