
local ae = require "apolloengine"
local mf = require "mathfunction"

local invert = {}

function invert:Initialize(host, size)
  self.renderObject = nil
  self.Queue = 100
  self.blendFactor = mf.vector1(100)
  self.lastBlendFactor = nil

  self.BLEND_FACTOR = ae.IMaterialSystem:NewParameterSlot(
    ae.ShaderEntity.UNIFORM,
    "BLEND_FACTOR")

  self.POST_EFFECT_ALPHA = ae.IMaterialSystem:NewParameterSlot(
    ae.ShaderEntity.UNIFORM,
    "POST_EFFECT_ALPHA");

  self.renderObject = host:CreateRenderObject("comm:documents/material/invert.material")
  self.renderObject:SetParameter(self.POST_EFFECT_ALPHA, mf.vector1(1.0));

  self:UpdateParameters()
  host:RegisterScriptParameter(self,"blendFactor");
  
  return self.Queue
end

function invert:Resizeview(size)

end

function invert:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget()
  Output:ClearBuffer(ae.RenderTargetEntity.CF_COLOR)

  self.renderObject:SetParameter(
          ae.ShaderEntity.TEXTURE_DIFFUSE,
          Scene:GetAttachment(ae.RenderTargetEntity.TA_COLOR_0));

  self:UpdateParameters()
  self.renderObject:Draw(pipeline)
end

function invert:UpdateParameters()
  if self.blendFactor ~= self.lastBlendFactor then
    self.renderObject:SetParameter(self.BLEND_FACTOR, mf.vector1(self.blendFactor:x() * 0.01))
    self.lastBlendFactor = self.blendFactor
  end
end

return invert;