local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

local lut = {}
lut.Do = 0;
lut.Queue = 310;

function lut:Initialize(host, size)
  self.lutPath = "comm:documents/texture/posteffect/lutpv.png";
  self.lastLutPath = "comm:documents/texture/posteffect/lutpv.png";
  self.tex = apolloengine.TextureEntity();
  self.tex:PushMetadata(apolloengine.TextureFileMetadata(
        apolloengine.TextureEntity.TU_STATIC,
        apolloengine.TextureEntity.PF_AUTO,1, false,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TF_NEAREST,
        apolloengine.TextureEntity.TF_NEAREST,
        self.lutPath));
  self.tex:SetJobType(venuscore.IJob.JT_SYNCHRONOUS);
  self.tex:CreateResource();
  self.LOOKUPTABLE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "LOOKUPTABLE");
  
  local pathout = venuscore.IFileSystem:PathAssembly("comm:documents/material/hald_lut.material");  
  self.Do = host:CreateRenderObject(pathout);
  self.Do:SetParameter(self.LOOKUPTABLE,self.tex);
  
  host:RegisterScriptParameter(self,"lutPath");
  return self.Queue;
end



function lut:Resizeview(size)
end

function lut:Process(pipeline, Original, Scene, Output)
  if(self.lutPath ~= self.lastLutPath)
  then
    self.newtex = apolloengine.TextureEntity();
    self.newtex:PushMetadata(apolloengine.TextureFileMetadata(
        apolloengine.TextureEntity.TU_STATIC,
        apolloengine.TextureEntity.PF_AUTO,1, false,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TF_NEAREST,
        apolloengine.TextureEntity.TF_NEAREST,
        self.lutPath));
    self.newtex:SetJobType(venuscore.IJob.JT_SYNCHRONOUS);
    self.newtex:CreateResource();
    self.Do:SetParameter(self.LOOKUPTABLE,self.newtex);
    self.lastLutPath = self.lutPath;
  end
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.Do:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.Do:Draw(pipeline);
end

return lut;