require "utility"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local glitch = {}

glitch.renderObject = nil;
glitch.queue = 100;

function glitch:Initialize(host, size)
  
  self.bounds1 = mathfunction.vector2(0.79,0.01);
  self.bounds2 = mathfunction.vector2(0.99,0.01);
  self.texelWidth = mathfunction.vector1(0.4);
  --self.thick = mathfunction.vector1(0.01);
  
  --self.renderObject = host:CreateRenderObject("comm:documents/shaders/opaque/glitch.material");
  self._MainTex = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"_MainTex");
  self._Bounds1 = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"_Bounds1");
  self._Bounds2 = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"_Bounds2");
  self._TexelWidth = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"_TexelWidth");
  
  
  self.renderObject = host:CreateRenderObject("comm:documents/shaders/posteffect/glitch.material");
  
  self:UpdateParameters();
 
  host:RegisterScriptParameter(self,"bounds1");
  host:RegisterScriptParameter(self,"bounds2");
  host:RegisterScriptParameter(self,"texelWidth");
  --host:RegisterScriptParameter(self,"thick");
  
  return self.queue;
end

function glitch:Resizeview(size)
--firstmaterialentity:SetParameter("_MainTex", tex);
end

function glitch:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget();
  Output:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
  self.renderObject:SetParameter(
          self._MainTex,
          Scene:GetAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0));
        
  self:UpdateParameters();
  
  self.renderObject:Draw(pipeline);
end

function glitch:UpdateParameters()
    local boundup1 =  self.bounds1:x()+self.bounds1:y();
    local boundup2 =  self.bounds2:x()+self.bounds2:y();
    
    local boundoffset1 = 0.5*(self.bounds1:x() + boundup1);
    local boundoffset2 = 0.5*(self.bounds2:x() + boundup2);
    
    self.renderObject:SetParameter(self._Bounds1, mathfunction.vector3(self.bounds1:x(),boundup1,boundoffset1));
    self.renderObject:SetParameter(self._Bounds2, mathfunction.vector3(self.bounds2:x(),boundup2,boundoffset2));
    self.renderObject:SetParameter(self._TexelWidth, self.texelWidth/100);
end

return glitch;