local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

local clear = {}
clear.Do = 0;

clear.Queue = 320;

--效果参数--


clear.blurAlpha_params = 0.6;

clear.sharpen_params = 0.05;

clear.smoothScaleFactor_params = 1.0;
--效果参数结束--

function clear:Initialize(host, size)
    
    self.texBlurWidthOffset1 = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "texBlurWidthOffset1");
    self.texBlurWidthOffset2 = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "texBlurWidthOffset2");
    self.texBlurWidthOffset3 = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "texBlurWidthOffset3");

    self.texBlurHeightOffset1 = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "texBlurHeightOffset1");   
    self.texBlurHeightOffset2 = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "texBlurHeightOffset2");
    self.texBlurHeightOffset3 = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "texBlurHeightOffset3"); 

    self.widthOffset = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "widthOffset"); 
    self.heightOffset = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "heightOffset"); 
    self.blurAlpha = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "blurAlpha"); 
    self.sharpen = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "sharpen"); 
    self.smoothScaleFactor = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "smoothScaleFactor");
    
        

    self.TEXTURE_DIFFUSE1 = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "TEXTURE_DIFFUSE1");
    self.TEXTURE_DIFFUSE2 = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "TEXTURE_DIFFUSE2");
    self.TEXTURE_DIFFUSE3 = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "TEXTURE_DIFFUSE3");
    self.srcImageTex1 = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "srcImageTex1");
    self.srcImageTex2 = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "srcImageTex2");
    self.blurImageTex2 = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "blurImageTex2");
    
    
        
    local pathblur = venuscore.IFileSystem:PathAssembly("comm:documents/material/Btblur.material");  
    self.btblur = host:CreateRenderObject(pathblur);   

    local pathedge = venuscore.IFileSystem:PathAssembly("comm:documents/material/Btedge.material");  
    self.btedge = host:CreateRenderObject(pathedge);   

    local pathbluralpha1 = venuscore.IFileSystem:PathAssembly("comm:documents/material/BtblurAlpha.material");  
    self.btbluralpha1 = host:CreateRenderObject(pathbluralpha1);   

    local pathbluralpha2 = venuscore.IFileSystem:PathAssembly("comm:documents/material/BtblurAlpha.material");  
    self.btbluralpha2 = host:CreateRenderObject(pathbluralpha2);   

    local pathfuse = venuscore.IFileSystem:PathAssembly("comm:documents/material/Btfuse.material");  
    self.btfuse = host:CreateRenderObject(pathfuse);   

    
   

    self.downsamplesize = mathfunction.vector2(size:x()/3,size:y()/3);
    self.blurRT = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_A, self.downsamplesize );

    self.edgeRT = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_B, self.downsamplesize );
    self.alphaRT1 = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_C, self.downsamplesize );
    self.alphaRT2 = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_D, self.downsamplesize );
    self.fuseRT = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_E, size );
   

    local downsamplesize = mathfunction.vector2(size:x()/3,size:y()/3);

    self:UpdateSize(size)
    
    self.btfuse:SetParameter(self.blurAlpha, mathfunction.vector1(self.blurAlpha_params)); 
    self.btfuse:SetParameter(self.sharpen,  mathfunction.vector1(self.sharpen_params));
    self.btfuse:SetParameter(self.smoothScaleFactor,  mathfunction.vector1(self.smoothScaleFactor_params));
      
    host:RegisterScriptParameter(self,"blurAlpha_params");
    host:RegisterScriptParameter(self,"sharpen_params");
    host:RegisterScriptParameter(self,"smoothScaleFactor_params");
    
    return self.Queue;
end

function clear:UpdateSize(size)  -- fortest
    self.size = size;
    self.downsamplesize = mathfunction.vector2(size:x()/3,size:y()/3);
    -- self.downsamplesize = mathfunction.vector2(size:x(),size:y());
    self.height= self.downsamplesize:y();
    
    self.hOffset=1.0/self.height;
    self.width=self.downsamplesize:x();
    self.wOffset=1.0/self.width;
    self.hOffset2 = 1.0 / size:y();
    self.wOffset2 = 1.0 / size:x();
    --self.Cartoon:SetParameter(self.PIXEL_OFFSETS, mathfunction.vector2( self.wOffset, self.hOffset ) );

   -- self.Downsample:SetParameter(self.DOWNSAMPLE_OFFSETS, mathfunction.vector2( self.wOffset, self.hOffset ) );
end


function clear:Resizeview(size)
    self:UpdateSize(size)
end

function clear:Blur(pipeline, Original, Scene, Output)
    self.blurRT:PushRenderTarget();
    self.blurRT:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);

    self.btblur:SetParameter(self.texBlurWidthOffset1, mathfunction.vector1(0));
    self.btblur:SetParameter(self.texBlurHeightOffset1, mathfunction.vector1(self.hOffset));  
    self.btblur:SetParameter(self.TEXTURE_DIFFUSE1,
        Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
      
    
		
	
     self.btblur:Draw(pipeline);
end

function clear:Edge(pipeline, Original, Scene, Output)
    self.edgeRT:PushRenderTarget();
    self.edgeRT:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
    
    
    self.btedge:SetParameter(self.TEXTURE_DIFFUSE2,
        self.blurRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));  
    
    self.btedge:SetParameter(self.srcImageTex1,
        Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));  
    self.btedge:SetParameter(self.texBlurWidthOffset2,mathfunction.vector1(self.wOffset) );
    self.btedge:SetParameter(self.texBlurHeightOffset2,mathfunction.vector1(0) );

    self.btedge:Draw(pipeline);
    
end


function clear:Alpha1(pipeline, Original, Scene, Output)
    self.alphaRT1:PushRenderTarget();
    self.alphaRT1:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);

    self.btbluralpha1:SetParameter(self.TEXTURE_DIFFUSE3,
        self.edgeRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));  
    
    
    self.btbluralpha1:SetParameter(self.texBlurWidthOffset3,mathfunction.vector1(0 ) );
    self.btbluralpha1:SetParameter(self.texBlurHeightOffset3,mathfunction.vector1(self.hOffset) );
    

    self.btbluralpha1:Draw(pipeline);
end


function clear:Alpha2(pipeline, Original, Scene, Output)
    self.alphaRT2:PushRenderTarget();
    self.alphaRT2:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
    -- Output:PushRenderTarget();
    -- Output:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
  


    self.btbluralpha2:SetParameter(self.TEXTURE_DIFFUSE3,
        self.alphaRT1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));  
    
    self.btbluralpha2:SetParameter(self.texBlurWidthOffset3,mathfunction.vector1(self.wOffset ) );
    self.btbluralpha2:SetParameter(self.texBlurHeightOffset3,mathfunction.vector1(0) );

    self.btbluralpha2:Draw(pipeline);

end


function clear:Fuse(pipeline, Original, Scene, Output)
    Output:PushRenderTarget();
    Output:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);

    self.btfuse:SetParameter(self.srcImageTex2,
        Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));  
    
    self.btfuse:SetParameter(self.blurImageTex2,
        self.alphaRT2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));  

    -- self.btfuse:SetParameter(self.widthOffset,mathfunction.vector1(1.0/self.size:x()) );
    -- self.btfuse:SetParameter(self.heightOffset,mathfunction.vector1(1.0/self.size:y()) );
    self.btfuse:SetParameter(self.widthOffset,mathfunction.vector1( self.wOffset2));
    self.btfuse:SetParameter(self.heightOffset,mathfunction.vector1(self.hOffset2) );
    self.btfuse:SetParameter(self.blurAlpha,mathfunction.vector1(self.blurAlpha_params) );
    self.btfuse:SetParameter(self.sharpen,mathfunction.vector1(self.sharpen_params) );
    self.btfuse:SetParameter(self.smoothScaleFactor,mathfunction.vector1(self.smoothScaleFactor_params) );
    self.btfuse:Draw(pipeline);
   
end


function clear:Process(pipeline, Original, Scene, Output)
    self:Blur(pipeline, Original, Scene, Output);
    self:Edge(pipeline, Original, Scene, Output);
    self:Alpha1(pipeline, Original, Scene, Output);
    self:Alpha2(pipeline, Original, Scene, Output);
    self:Fuse(pipeline, Original, Scene, Output);
    
end

return clear;

